% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rearrangement-estimation.R
\name{Rearrangement.estimation}
\alias{Rearrangement.estimation}
\title{Estimates a monotonic regression curve via Chernozhukov et al (2009)}
\usage{
Rearrangement.estimation(Y, Index, t = Index, weights = NULL, degree.pol = 1)
}
\arguments{
\item{Y}{The response variable.}

\item{Index}{The estimated index. The user may obtain it using function \code{\link{Lorenz.Reg}}.}

\item{t}{A vector of points over which the link function \eqn{H(.)} should be estimated. Default is the estimated index.}

\item{weights}{vector of sample weights. By default, each observation is given the same weight.}

\item{degree.pol}{degree of the polynomial used in the local polynomial regression. Default value is 1.}
}
\value{
A list with the following components
\describe{
    \item{\code{t}}{the points over which the estimation has been undertaken.}
    \item{\code{H}}{the estimated link function evaluated at \emph{t}.}
}
}
\description{
\code{Rearrangement.estimation} estimates the increasing link function of a single index model via the methodology proposed in Chernozhukov et al (2009).
}
\details{
A first estimator of the link function, neglecting the assumption of monotonicity, is obtained with function \code{\link[locpol]{locpol}} from the \emph{locpol} package.
The final estimator is obtained through the rearrangement operation explained in Chernozhukov et al (2009). This operation is carried out with function \code{\link[Rearrangement]{rearrangement}} from package \emph{Rearrangement}.
}
\section{References}{

Chernozhukov, V., I. Fernández-Val, and A. Galichon (2009). Improving Point and Interval Estimators of Monotone Functions by Rearrangement. \emph{Biometrika 96 (3)}. 559–75.
}

\examples{
data(Data.Incomes)
PLR <- Lorenz.Reg(Income ~ ., data = Data.Incomes,
                  penalty = "SCAD", eps = 0.01)
Y <- PLR$y
Index <- predict(PLR)
Rearrangement.estimation(Y = Y, Index = Index)

}
\seealso{
\code{\link{Lorenz.Reg}}, \code{\link[locpol]{locpol}}, \code{\link[Rearrangement]{rearrangement}}
}
