% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_spde.R
\name{predict.inla_metric_graph_spde}
\alias{predict.inla_metric_graph_spde}
\title{Predict method for 'inlabru' fits on Metric Graphs}
\usage{
\method{predict}{inla_metric_graph_spde}(
  object,
  cmp,
  bru_fit,
  newdata = NULL,
  formula = NULL,
  data_coords = c("PtE", "euclidean"),
  normalized = TRUE,
  repl = NULL,
  repl_col = NULL,
  group = NULL,
  group_col = NULL,
  n.samples = 100,
  seed = 0L,
  probs = c(0.025, 0.5, 0.975),
  return_original_order = TRUE,
  num.threads = NULL,
  include = NULL,
  exclude = NULL,
  drop = FALSE,
  tolerance_merge = 1e-05,
  ...,
  data = deprecated()
)
}
\arguments{
\item{object}{An \code{inla_metric_graph_spde} object built with the \code{graph_spde()}
function.}

\item{cmp}{The 'inlabru' component used to fit the model.}

\item{bru_fit}{A fitted model using 'inlabru' or 'INLA'.}

\item{newdata}{A data.frame of covariates needed for the prediction. The
locations must be normalized PtE.}

\item{formula}{A formula where the right hand side defines an R expression to
evaluate for each generated sample. If NULL, the latent and hyperparameter
states are returned as named list elements. See Details for more information.}

\item{data_coords}{It decides which coordinate system to use. If \code{PtE}, the
user must provide the locations as a data frame with the first column being
the edge number and the second column as the distance on edge, otherwise if
\code{euclidean}, the user must provide a data frame with the first column being
the \code{x} Euclidean coordinates and the second column being the \code{y} Euclidean
coordinates.}

\item{normalized}{if \code{TRUE}, then the distances in distance on edge are
assumed to be normalized to (0,1). Default TRUE. Will not be
used if \code{data_coords} is \code{euclidean}.}

\item{repl}{Which replicates? If there is no replicates, one
can set \code{repl} to \code{NULL}. If one wants all replicates,
then one sets to \code{repl} to \code{.all}.}

\item{repl_col}{Column containing the replicates. If the replicate is the internal group variable, set the replicates
to ".group". If not replicates, set to \code{NULL}.}

\item{group}{Which groups? If there is no groups, one
can set \code{group} to \code{NULL}. If one wants all groups,
then one sets to \code{group} to \code{.all}.}

\item{group_col}{Which "column" of the data contains the group variable?}

\item{n.samples}{Integer setting the number of samples to draw in order to
calculate the posterior statistics. The default is rather low but provides a
quick approximate result.}

\item{seed}{Random number generator seed passed on to \code{inla.posterior.sample()}}

\item{probs}{A numeric vector of probabilities with values in the standard
unit interval to be passed to stats::quantile}

\item{return_original_order}{Should the predictions be returned in the
original order?}

\item{num.threads}{Specification of desired number of threads for parallel
computations. Default NULL, leaves it up to 'INLA'. When seed != 0, overridden to "1:1"}

\item{include}{Character vector of component labels that are needed by the
predictor expression; Default: NULL (include all components that are not
explicitly excluded)}

\item{exclude}{Character vector of component labels that are not used by the
predictor expression. The exclusion list is applied to the list as determined
by the include parameter; Default: NULL (do not remove any components from
the inclusion list)}

\item{drop}{logical; If keep=FALSE, data is a SpatialDataFrame, and the
prediciton summary has the same number of rows as data, then the output is a
SpatialDataFrame object. Default FALSE.}

\item{tolerance_merge}{Tolerance for merging prediction points into original points to increase stability.}

\item{...}{Additional arguments passed on to \code{inla.posterior.sample()}.}

\item{data}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use \code{newdata} instead.}
}
\value{
A list with predictions.
}
\description{
Auxiliar function to obtain predictions of the field
using 'inlabru'.
}
