% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poset_from_igraph.R
\name{poset_from_igraph}
\alias{poset_from_igraph}
\title{Generates a Partially Ordered SET from a Directed Acyclic Graph (DAG)}
\usage{
poset_from_igraph(g)
}
\arguments{
\item{g}{an \code{igraph} object}
}
\value{
an environment of class \code{poset}.
}
\description{
This function generates a poset from an object\code{g}. The function checks if the graph is directed and cyclic in oreder it represent the cover-relation.
}
\details{
Note that the Hasse diagram represents the cover relation from the top to the bottom, therefore its representation is the opposite of the plot of the graph with Sugiyama layout.
}
\examples{
library(igraph)
g <- make_tree(10)
ly <- igraph::layout_with_sugiyama(g)$layout
g$layout <- ly
plot(g)
p <- poset_from_igraph(g)
plot(p)
}
\references{
\insertRef{davey2002introduction}{POSetR}
}
\seealso{
\code{\link[POSetR]{poset}}.
}
