% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AutoSmCCNet.R
\name{getCanCorMulti}
\alias{getCanCorMulti}
\title{Canonical Correlation Value for SmCCA}
\usage{
getCanCorMulti(X, CCcoef, CCWeight, Y)
}
\arguments{
\item{X}{A list of data each with same number of subjects.}

\item{CCcoef}{A vector of scaling factors indicating weights for each pairwise canonical correlation.}

\item{CCWeight}{A list of canonical weight vectors corresponds to each data in \eqn{X}.}

\item{Y}{A phenotype matrix, should have only one column.}
}
\value{
A numeric value of the total canonical correlation
}
\description{
Calculate canonical correlation value for SmCCA given canonical weight vectors and scaling factor
}
\examples{
library(SmCCNet)
data("ExampleData")
getCanCorMulti(list(X1,X2), CCcoef = c(1,1,1), 
CCWeight = list(rnorm(500,0,1), rnorm(100,0,1)), Y = Y)
}
