# Copyright (C) 2011 Jelmer Ypma. All Rights Reserved.
# This code is published under the GPL.
#
# File:   KPU.R
# Author: Jelmer Ypma
# Date:   31 March 2011
#
# This code is based on code from www.sparse-grids.de
# with permission from the authors.
#
# Input: 
# Output: 

KPU <- function( level ) {
  switch( level,
          { # case 1
            n = c(5.0000000000000000e-001)
            w = c(1.0000000000000000e+000)
          },
          { # case 2
            n = c(5.0000000000000000e-001, 8.8729829999999998e-001)
            w = c(4.4444440000000002e-001, 2.7777780000000002e-001)
          },
          { # case 3
            n = c(5.0000000000000000e-001, 8.8729829999999998e-001)
            w = c(4.4444440000000002e-001, 2.7777780000000002e-001)
          },
          { # case 4
            n = c(5.0000000000000000e-001, 7.1712189999999998e-001, 8.8729829999999998e-001, 9.8024560000000005e-001)
            w = c(2.2545832254583223e-001, 2.0069872006987199e-001, 1.3424401342440134e-001, 5.2328105232810521e-002)
          },
          { # case 5
            n = c(5.0000000000000000e-001, 7.1712189999999998e-001, 8.8729829999999998e-001, 9.8024560000000005e-001)
            w = c(2.2545832254583223e-001, 2.0069872006987199e-001, 1.3424401342440134e-001, 5.2328105232810521e-002)
          },
          { # case 6
            n = c(5.0000000000000000e-001, 7.1712189999999998e-001, 8.8729829999999998e-001, 9.8024560000000005e-001)
            w = c(2.2545832254583223e-001, 2.0069872006987199e-001, 1.3424401342440134e-001, 5.2328105232810521e-002)
          },
          { # case 7
            n = c(5.0000000000000000e-001, 6.1169330000000000e-001, 7.1712189999999998e-001, 8.1055149999999998e-001, 8.8729829999999998e-001, 9.4422960000000000e-001, 9.8024560000000005e-001, 9.9691600000000002e-001)
            w = c(1.1275520000000000e-001, 1.0957840000000001e-001, 1.0031430000000000e-001, 8.5755999999999999e-002, 6.7207600000000006e-002, 4.6463600000000001e-002, 2.5801600000000001e-002, 8.5009000000000005e-003)
          },
          { # case 8
            n = c(5.0000000000000000e-001, 6.1169330000000000e-001, 7.1712189999999998e-001, 8.1055149999999998e-001, 8.8729829999999998e-001, 9.4422960000000000e-001, 9.8024560000000005e-001, 9.9691600000000002e-001)
            w = c(1.1275520000000000e-001, 1.0957840000000001e-001, 1.0031430000000000e-001, 8.5755999999999999e-002, 6.7207600000000006e-002, 4.6463600000000001e-002, 2.5801600000000001e-002, 8.5009000000000005e-003)
          },
          { # case 9
            n = c(5.0000000000000000e-001, 6.1169330000000000e-001, 7.1712189999999998e-001, 8.1055149999999998e-001, 8.8729829999999998e-001, 9.4422960000000000e-001, 9.8024560000000005e-001, 9.9691600000000002e-001)
            w = c(1.1275520000000000e-001, 1.0957840000000001e-001, 1.0031430000000000e-001, 8.5755999999999999e-002, 6.7207600000000006e-002, 4.6463600000000001e-002, 2.5801600000000001e-002, 8.5009000000000005e-003)
          },
          { # case 10
            n = c(5.0000000000000000e-001, 6.1169330000000000e-001, 7.1712189999999998e-001, 8.1055149999999998e-001, 8.8729829999999998e-001, 9.4422960000000000e-001, 9.8024560000000005e-001, 9.9691600000000002e-001)
            w = c(1.1275520000000000e-001, 1.0957840000000001e-001, 1.0031430000000000e-001, 8.5755999999999999e-002, 6.7207600000000006e-002, 4.6463600000000001e-002, 2.5801600000000001e-002, 8.5009000000000005e-003)
          },
          { # case 11
            n = c(5.0000000000000000e-001, 6.1169330000000000e-001, 7.1712189999999998e-001, 8.1055149999999998e-001, 8.8729829999999998e-001, 9.4422960000000000e-001, 9.8024560000000005e-001, 9.9691600000000002e-001)
            w = c(1.1275520000000000e-001, 1.0957840000000001e-001, 1.0031430000000000e-001, 8.5755999999999999e-002, 6.7207600000000006e-002, 4.6463600000000001e-002, 2.5801600000000001e-002, 8.5009000000000005e-003)
          },
          { # case 12
            n = c(5.0000000000000000e-001, 6.1169330000000000e-001, 7.1712189999999998e-001, 8.1055149999999998e-001, 8.8729829999999998e-001, 9.4422960000000000e-001, 9.8024560000000005e-001, 9.9691600000000002e-001)
            w = c(1.1275520000000000e-001, 1.0957840000000001e-001, 1.0031430000000000e-001, 8.5755999999999999e-002, 6.7207600000000006e-002, 4.6463600000000001e-002, 2.5801600000000001e-002, 8.5009000000000005e-003)
          },
          { # case 13
            n = c(5.0000000000000000e-001, 5.5624450000000003e-001, 6.1169330000000000e-001, 6.6556769999999998e-001, 7.1712189999999998e-001, 7.6565989999999995e-001, 8.1055149999999998e-001, 8.5124809999999995e-001, 8.8729829999999998e-001, 9.1836300000000004e-001, 9.4422960000000000e-001, 9.6482740000000000e-001, 9.8024560000000005e-001, 9.9076560000000002e-001, 9.9691600000000002e-001, 9.9954909999999997e-001)
            w = c(5.6377600000000014e-002, 5.5978400000000011e-002, 5.4789200000000017e-002, 5.2834900000000011e-002, 5.0157100000000017e-002, 4.6813600000000004e-002, 4.2878000000000006e-002, 3.8439800000000010e-002, 3.3603900000000006e-002, 2.8489800000000006e-002, 2.3231400000000003e-002, 1.7978600000000004e-002, 1.2903800000000003e-002, 8.2230000000000011e-003, 4.2173000000000011e-003, 1.2724000000000001e-003)
          },
          { # case 14
            n = c(5.0000000000000000e-001, 5.5624450000000003e-001, 6.1169330000000000e-001, 6.6556769999999998e-001, 7.1712189999999998e-001, 7.6565989999999995e-001, 8.1055149999999998e-001, 8.5124809999999995e-001, 8.8729829999999998e-001, 9.1836300000000004e-001, 9.4422960000000000e-001, 9.6482740000000000e-001, 9.8024560000000005e-001, 9.9076560000000002e-001, 9.9691600000000002e-001, 9.9954909999999997e-001)
            w = c(5.6377600000000014e-002, 5.5978400000000011e-002, 5.4789200000000017e-002, 5.2834900000000011e-002, 5.0157100000000017e-002, 4.6813600000000004e-002, 4.2878000000000006e-002, 3.8439800000000010e-002, 3.3603900000000006e-002, 2.8489800000000006e-002, 2.3231400000000003e-002, 1.7978600000000004e-002, 1.2903800000000003e-002, 8.2230000000000011e-003, 4.2173000000000011e-003, 1.2724000000000001e-003)
          },
          { # case 15
            n = c(5.0000000000000000e-001, 5.5624450000000003e-001, 6.1169330000000000e-001, 6.6556769999999998e-001, 7.1712189999999998e-001, 7.6565989999999995e-001, 8.1055149999999998e-001, 8.5124809999999995e-001, 8.8729829999999998e-001, 9.1836300000000004e-001, 9.4422960000000000e-001, 9.6482740000000000e-001, 9.8024560000000005e-001, 9.9076560000000002e-001, 9.9691600000000002e-001, 9.9954909999999997e-001)
            w = c(5.6377600000000014e-002, 5.5978400000000011e-002, 5.4789200000000017e-002, 5.2834900000000011e-002, 5.0157100000000017e-002, 4.6813600000000004e-002, 4.2878000000000006e-002, 3.8439800000000010e-002, 3.3603900000000006e-002, 2.8489800000000006e-002, 2.3231400000000003e-002, 1.7978600000000004e-002, 1.2903800000000003e-002, 8.2230000000000011e-003, 4.2173000000000011e-003, 1.2724000000000001e-003)
          },
          { # case 16
            n = c(5.0000000000000000e-001, 5.5624450000000003e-001, 6.1169330000000000e-001, 6.6556769999999998e-001, 7.1712189999999998e-001, 7.6565989999999995e-001, 8.1055149999999998e-001, 8.5124809999999995e-001, 8.8729829999999998e-001, 9.1836300000000004e-001, 9.4422960000000000e-001, 9.6482740000000000e-001, 9.8024560000000005e-001, 9.9076560000000002e-001, 9.9691600000000002e-001, 9.9954909999999997e-001)
            w = c(5.6377600000000014e-002, 5.5978400000000011e-002, 5.4789200000000017e-002, 5.2834900000000011e-002, 5.0157100000000017e-002, 4.6813600000000004e-002, 4.2878000000000006e-002, 3.8439800000000010e-002, 3.3603900000000006e-002, 2.8489800000000006e-002, 2.3231400000000003e-002, 1.7978600000000004e-002, 1.2903800000000003e-002, 8.2230000000000011e-003, 4.2173000000000011e-003, 1.2724000000000001e-003)
          },
          { # case 17
            n = c(5.0000000000000000e-001, 5.5624450000000003e-001, 6.1169330000000000e-001, 6.6556769999999998e-001, 7.1712189999999998e-001, 7.6565989999999995e-001, 8.1055149999999998e-001, 8.5124809999999995e-001, 8.8729829999999998e-001, 9.1836300000000004e-001, 9.4422960000000000e-001, 9.6482740000000000e-001, 9.8024560000000005e-001, 9.9076560000000002e-001, 9.9691600000000002e-001, 9.9954909999999997e-001)
            w = c(5.6377600000000014e-002, 5.5978400000000011e-002, 5.4789200000000017e-002, 5.2834900000000011e-002, 5.0157100000000017e-002, 4.6813600000000004e-002, 4.2878000000000006e-002, 3.8439800000000010e-002, 3.3603900000000006e-002, 2.8489800000000006e-002, 2.3231400000000003e-002, 1.7978600000000004e-002, 1.2903800000000003e-002, 8.2230000000000011e-003, 4.2173000000000011e-003, 1.2724000000000001e-003)
          },
          { # case 18
            n = c(5.0000000000000000e-001, 5.5624450000000003e-001, 6.1169330000000000e-001, 6.6556769999999998e-001, 7.1712189999999998e-001, 7.6565989999999995e-001, 8.1055149999999998e-001, 8.5124809999999995e-001, 8.8729829999999998e-001, 9.1836300000000004e-001, 9.4422960000000000e-001, 9.6482740000000000e-001, 9.8024560000000005e-001, 9.9076560000000002e-001, 9.9691600000000002e-001, 9.9954909999999997e-001)
            w = c(5.6377600000000014e-002, 5.5978400000000011e-002, 5.4789200000000017e-002, 5.2834900000000011e-002, 5.0157100000000017e-002, 4.6813600000000004e-002, 4.2878000000000006e-002, 3.8439800000000010e-002, 3.3603900000000006e-002, 2.8489800000000006e-002, 2.3231400000000003e-002, 1.7978600000000004e-002, 1.2903800000000003e-002, 8.2230000000000011e-003, 4.2173000000000011e-003, 1.2724000000000001e-003)
          },
          { # case 19
            n = c(5.0000000000000000e-001, 5.5624450000000003e-001, 6.1169330000000000e-001, 6.6556769999999998e-001, 7.1712189999999998e-001, 7.6565989999999995e-001, 8.1055149999999998e-001, 8.5124809999999995e-001, 8.8729829999999998e-001, 9.1836300000000004e-001, 9.4422960000000000e-001, 9.6482740000000000e-001, 9.8024560000000005e-001, 9.9076560000000002e-001, 9.9691600000000002e-001, 9.9954909999999997e-001)
            w = c(5.6377600000000014e-002, 5.5978400000000011e-002, 5.4789200000000017e-002, 5.2834900000000011e-002, 5.0157100000000017e-002, 4.6813600000000004e-002, 4.2878000000000006e-002, 3.8439800000000010e-002, 3.3603900000000006e-002, 2.8489800000000006e-002, 2.3231400000000003e-002, 1.7978600000000004e-002, 1.2903800000000003e-002, 8.2230000000000011e-003, 4.2173000000000011e-003, 1.2724000000000001e-003)
          },
          { # case 20
            n = c(5.0000000000000000e-001, 5.5624450000000003e-001, 6.1169330000000000e-001, 6.6556769999999998e-001, 7.1712189999999998e-001, 7.6565989999999995e-001, 8.1055149999999998e-001, 8.5124809999999995e-001, 8.8729829999999998e-001, 9.1836300000000004e-001, 9.4422960000000000e-001, 9.6482740000000000e-001, 9.8024560000000005e-001, 9.9076560000000002e-001, 9.9691600000000002e-001, 9.9954909999999997e-001)
            w = c(5.6377600000000014e-002, 5.5978400000000011e-002, 5.4789200000000017e-002, 5.2834900000000011e-002, 5.0157100000000017e-002, 4.6813600000000004e-002, 4.2878000000000006e-002, 3.8439800000000010e-002, 3.3603900000000006e-002, 2.8489800000000006e-002, 2.3231400000000003e-002, 1.7978600000000004e-002, 1.2903800000000003e-002, 8.2230000000000011e-003, 4.2173000000000011e-003, 1.2724000000000001e-003)
          },
          { # case 21
            n = c(5.0000000000000000e-001, 5.5624450000000003e-001, 6.1169330000000000e-001, 6.6556769999999998e-001, 7.1712189999999998e-001, 7.6565989999999995e-001, 8.1055149999999998e-001, 8.5124809999999995e-001, 8.8729829999999998e-001, 9.1836300000000004e-001, 9.4422960000000000e-001, 9.6482740000000000e-001, 9.8024560000000005e-001, 9.9076560000000002e-001, 9.9691600000000002e-001, 9.9954909999999997e-001)
            w = c(5.6377600000000014e-002, 5.5978400000000011e-002, 5.4789200000000017e-002, 5.2834900000000011e-002, 5.0157100000000017e-002, 4.6813600000000004e-002, 4.2878000000000006e-002, 3.8439800000000010e-002, 3.3603900000000006e-002, 2.8489800000000006e-002, 2.3231400000000003e-002, 1.7978600000000004e-002, 1.2903800000000003e-002, 8.2230000000000011e-003, 4.2173000000000011e-003, 1.2724000000000001e-003)
          },
          { # case 22
            n = c(5.0000000000000000e-001, 5.5624450000000003e-001, 6.1169330000000000e-001, 6.6556769999999998e-001, 7.1712189999999998e-001, 7.6565989999999995e-001, 8.1055149999999998e-001, 8.5124809999999995e-001, 8.8729829999999998e-001, 9.1836300000000004e-001, 9.4422960000000000e-001, 9.6482740000000000e-001, 9.8024560000000005e-001, 9.9076560000000002e-001, 9.9691600000000002e-001, 9.9954909999999997e-001)
            w = c(5.6377600000000014e-002, 5.5978400000000011e-002, 5.4789200000000017e-002, 5.2834900000000011e-002, 5.0157100000000017e-002, 4.6813600000000004e-002, 4.2878000000000006e-002, 3.8439800000000010e-002, 3.3603900000000006e-002, 2.8489800000000006e-002, 2.3231400000000003e-002, 1.7978600000000004e-002, 1.2903800000000003e-002, 8.2230000000000011e-003, 4.2173000000000011e-003, 1.2724000000000001e-003)
          },
          { # case 23
            n = c(5.0000000000000000e-001, 5.5624450000000003e-001, 6.1169330000000000e-001, 6.6556769999999998e-001, 7.1712189999999998e-001, 7.6565989999999995e-001, 8.1055149999999998e-001, 8.5124809999999995e-001, 8.8729829999999998e-001, 9.1836300000000004e-001, 9.4422960000000000e-001, 9.6482740000000000e-001, 9.8024560000000005e-001, 9.9076560000000002e-001, 9.9691600000000002e-001, 9.9954909999999997e-001)
            w = c(5.6377600000000014e-002, 5.5978400000000011e-002, 5.4789200000000017e-002, 5.2834900000000011e-002, 5.0157100000000017e-002, 4.6813600000000004e-002, 4.2878000000000006e-002, 3.8439800000000010e-002, 3.3603900000000006e-002, 2.8489800000000006e-002, 2.3231400000000003e-002, 1.7978600000000004e-002, 1.2903800000000003e-002, 8.2230000000000011e-003, 4.2173000000000011e-003, 1.2724000000000001e-003)
          },
          { # case 24
            n = c(5.0000000000000000e-001, 5.5624450000000003e-001, 6.1169330000000000e-001, 6.6556769999999998e-001, 7.1712189999999998e-001, 7.6565989999999995e-001, 8.1055149999999998e-001, 8.5124809999999995e-001, 8.8729829999999998e-001, 9.1836300000000004e-001, 9.4422960000000000e-001, 9.6482740000000000e-001, 9.8024560000000005e-001, 9.9076560000000002e-001, 9.9691600000000002e-001, 9.9954909999999997e-001)
            w = c(5.6377600000000014e-002, 5.5978400000000011e-002, 5.4789200000000017e-002, 5.2834900000000011e-002, 5.0157100000000017e-002, 4.6813600000000004e-002, 4.2878000000000006e-002, 3.8439800000000010e-002, 3.3603900000000006e-002, 2.8489800000000006e-002, 2.3231400000000003e-002, 1.7978600000000004e-002, 1.2903800000000003e-002, 8.2230000000000011e-003, 4.2173000000000011e-003, 1.2724000000000001e-003)
          },
          { # case 25
            n = c(5.0000000000000000e-001, 5.2817210000000003e-001, 5.5624450000000003e-001, 5.8411769999999996e-001, 6.1169330000000000e-001, 6.3887490000000002e-001, 6.6556769999999998e-001, 6.9167970000000001e-001, 7.1712189999999998e-001, 7.4180900000000005e-001, 7.6565989999999995e-001, 7.8859789999999996e-001, 8.1055149999999998e-001, 8.3145480000000005e-001, 8.5124809999999995e-001, 8.6987800000000004e-001, 8.8729829999999998e-001, 9.0347029999999995e-001, 9.1836300000000004e-001, 9.3195399999999995e-001, 9.4422960000000000e-001, 9.5518559999999997e-001, 9.6482740000000000e-001, 9.7317140000000002e-001, 9.8024560000000005e-001, 9.8609139999999995e-001, 9.9076560000000002e-001, 9.9434239999999996e-001, 9.9691600000000002e-001, 9.9860309999999997e-001, 9.9954909999999997e-001, 9.9993650000000001e-001)
            w = c(2.8188799999999993e-002, 2.8138799999999992e-002, 2.7989199999999992e-002, 2.7740699999999993e-002, 2.7394599999999995e-002, 2.6952699999999993e-002, 2.6417499999999993e-002, 2.5791599999999994e-002, 2.5078599999999993e-002, 2.4282199999999993e-002, 2.3406799999999995e-002, 2.2457299999999996e-002, 2.1438999999999996e-002, 2.0357799999999995e-002, 1.9219899999999998e-002, 1.8032199999999998e-002, 1.6801899999999998e-002, 1.5536799999999996e-002, 1.4244899999999996e-002, 1.2934799999999996e-002, 1.1615699999999998e-002, 1.0297099999999998e-002, 8.9892999999999987e-003, 7.7033999999999983e-003, 6.4518999999999983e-003, 5.2490999999999987e-003, 4.1114999999999988e-003, 3.0577999999999990e-003, 2.1087999999999997e-003, 1.2894999999999998e-003, 6.3259999999999987e-004, 1.8159999999999997e-004)
        }
    )   # end switch
  
    return( list( "nodes"     = n,
                  "weights"   = w ) )
}

