% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TRDemo.R
\name{TRDemo}
\alias{TRDemo}
\title{A 'shiny' Taylor-Russell demonstration program}
\usage{
TRDemo()
}
\value{
No return value.
}
\description{
{
\code{TRDemo()} is an R 'shiny' function for illustrating the bivariate 
(i.e., single predictor) Taylor-Russell model for 
personnel selection. The function can be called 
from the command prompt (\code{>}) by typing:

\code{TRDemo()}
}

After calling the function, users are asked to enter values for 3 of the 
following 4 variables:
\itemize{
 \item The Base Rate (BR) of successful criterion performance 
 (i.e., within the target population, the proportion of individuals who 
 successfully execute the job demands). 
 \item The Selection Ratio (SR; i.e., the proportion of hired candidates within 
 the target population).
 \item The Criterion Validity (CV; the correlation between the selection test 
 and an operationalized measure of job performance).
 \item The Positive Predicted Value (PPV; The probability that a hired 
 individual can successfully execute the 
 job demands).
 }
}
\details{
\code{TRDemo()} is a 'shiny' program for demonstrating the 
classic Taylor-Russell model for personnel selection.


 \code{TRDemo()} calculates the model-implied value for the omitted 
 variable and prints all model parameters (e.g., BR, SR, 
 CV, and PPV) to 
 screen. Given these parameters, the function also reports the test Sensitivity 
 (defined as the probability that a qualified individual will be hired) and 
 test Specificity (defined as the probability that an unqualified individual 
 will not be hired). Finally, the function plots a 
 correlation ellipse (associated with the CV) showing the relative 
 proportions of True Positives (TP; hired individuals who are 
 qualified for the job), False Positives (FP; hired individuals who are not 
 qualified for the job), True Negatives (TN; non hired individuals who are 
 not qualified for the job), and  
 False Negatives (FN; non hired individuals who are qualified for the job).
}
\examples{

# Type TRDemo() from the command prompt (>) to run the 'shiny' app
# in interactive mode.
 
 

}
\references{
\itemize{
  \item Taylor, H. C. & Russell, J. (1939). The relationship of validity 
  coefficients to the practical effectiveness of tests in selection: 
  Discussion and tables. \emph{Journal of Applied Psychology, 23}, 565--578.
 }
}
\author{
\itemize{
  \item Niels G. Waller (nwaller@umn.edu)
  \item Ziyu Ren
}
}
\keyword{stats}
