% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS_extended.R
\name{dMTS}
\alias{dMTS}
\title{Density function of the modified tempered stable (MTS) distribution}
\usage{
dMTS(
  x,
  alpha = NULL,
  delta = NULL,
  lambdap = NULL,
  lambdam = NULL,
  mu = NULL,
  theta = NULL,
  dens_method = "FFT",
  a = -20,
  b = 20,
  nf = 256
)
}
\arguments{
\item{x}{A numeric vector of quantiles.}

\item{alpha}{Stability parameter. A real number between 0 and 2.}

\item{delta}{Scale parameter. A real number > 0.}

\item{lambdap, lambdam}{Tempering parameter. A real number > 0.}

\item{mu}{A location parameter, any real number.}

\item{theta}{Parameters stacked as a vector.}

\item{dens_method}{A method to get the density function. Here, only "FFT" is
available.}

\item{a}{Starting point of FFT, if \code{dens_method == "FFT"}. -20
by default.}

\item{b}{Ending point of FFT, if \code{dens_method == "FFT"}. 20
by default.}

\item{nf}{Pieces the transformation is divided in. Limited to power-of-two
size. 256 by default.}
}
\value{
As \code{x} is a numeric vector, the return value is also a numeric
vector of densities.
}
\description{
\code{theta} denotes the parameter vector \code{(alpha, delta, lambdap,
lambdam, mu)}. The probability density function (PDF) of the modified
tempered stable distributions is not available in closed form.
Relies on fast Fourier transform (FFT) applied to the characteristic
function.
}
\details{
For examples, compare with \code{\link[=dCTS]{dCTS()}}.
}
