% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicfcts_TS.R
\name{pCTS}
\alias{pCTS}
\title{Cumulative probability function of the classical tempered stable (CTS)
distribution}
\usage{
pCTS(
  q,
  alpha = NULL,
  deltap = NULL,
  deltam = NULL,
  lambdap = NULL,
  lambdam = NULL,
  mu = NULL,
  theta = NULL,
  a = -40,
  b = 40,
  nf = 2^13,
  ...
)
}
\arguments{
\item{q}{A numeric vector of quantiles.}

\item{alpha}{Stability parameter. A real number between 0 and 2.}

\item{deltap}{Scale parameter for the right tail. A real number > 0.}

\item{deltam}{Scale parameter for the left tail. A real number > 0.}

\item{lambdap}{Tempering parameter for the right tail. A real number > 0.}

\item{lambdam}{Tempering parameter for the left tail. A real number > 0.}

\item{mu}{A location parameter, any real number.}

\item{theta}{Parameters stacked as a vector.}

\item{a}{Starting point of FFT, if \code{dens_method == "FFT"}. -20
by default.}

\item{b}{Ending point of FFT, if \code{dens_method == "FFT"}. 20
by default.}

\item{nf}{Pieces the transformation is divided in. Limited to power-of-two
size.}

\item{...}{Possibility to modify \code{stats::integrate()}.}
}
\value{
As \code{q} is a numeric vector, the return value is also a numeric
vector of probabilities.
}
\description{
The cumulative probability distribution function (CDF) of the classical
tempered stable distribution.
}
\details{
\code{theta} denotes the parameter vector \code{(alpha, deltap, deltam,
lambdap, lambdam, mu)}. Either provide the parameters individually OR
provide \code{theta}.
The function integrates the PDF numerically with \code{integrate()}.
}
\examples{
\donttest{
x <- seq(-5,5,0.25)
y <- pCTS(x,0.5,1,1,1,1,1)
plot(x,y)
}

}
\seealso{
See also the \code{\link[=dCTS]{dCTS()}} density-function.
}
