% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KNN.R
\name{knn_parallel}
\alias{knn_parallel}
\title{Find K nearest neighbours for multiple query points}
\usage{
knn_parallel(data, query = data, k, ..., ncores = bigparallelr::nb_cores())
}
\arguments{
\item{data}{Mxd matrix of M target points with dimension d}

\item{query}{Nxd matrix of N query points with dimension d (nb \code{data} 
and \code{query} must have same dimension). If missing defaults to 
\code{data} i.e. a self-query.}

\item{k}{an integer number of nearest neighbours to find}

\item{...}{
  Arguments passed on to \code{\link[nabor:knn]{nabor::knn}}
  \describe{
    \item{\code{eps}}{An approximate error bound. The default of 0 implies exact 
matching.}
    \item{\code{searchtype}}{A character vector or integer indicating the search type. 
The default value of \code{1L} is equivalent to "auto". See details.}
    \item{\code{radius}}{Maximum radius search bound. The default of 0 implies no radius
bound.}
  }}

\item{ncores}{Number of cores to use. Default uses \code{\link[bigparallelr:nb_cores]{bigparallelr::nb_cores()}}.}
}
\value{
A list with elements \code{nn.idx} (1-indexed indices) and 
  \code{nn.dists} (distances), both of which are N x k matrices. See details
  for the results obtained with1 invalid inputs.
}
\description{
Find K nearest neighbours for multiple query points
}
\examples{
\dontrun{knn_parallel(matrix(1:4, 2), k = 2, ncores = 2)}

}
