% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getters.R
\name{get_parameter_types}
\alias{get_parameter_types}
\alias{get_parameter_types.dynamitefit}
\title{Get Parameter Types of the Dynamite Model}
\usage{
get_parameter_types(x, ...)

\method{get_parameter_types}{dynamitefit}(x, ...)
}
\arguments{
\item{x}{[\code{dynamitefit}]\cr The model fit object.}

\item{...}{Ignored.}
}
\value{
A \code{character} vector with all parameter types of the input model.
}
\description{
Extracts all parameter types of used in the \code{dynamitefit} object. See
\code{\link[=as.data.frame.dynamitefit]{as.data.frame.dynamitefit()}} for explanations of different types.
}
\examples{
data.table::setDTthreads(1) # For CRAN
get_parameter_types(multichannel_example_fit)

}
\seealso{
Model outputs
\code{\link{as.data.frame.dynamitefit}()},
\code{\link{as.data.table.dynamitefit}()},
\code{\link{as_draws_df.dynamitefit}()},
\code{\link{coef.dynamitefit}()},
\code{\link{confint.dynamitefit}()},
\code{\link{dynamite}()},
\code{\link{get_code}()},
\code{\link{get_data}()},
\code{\link{get_parameter_dims}()},
\code{\link{get_parameter_names}()},
\code{\link{ndraws.dynamitefit}()},
\code{\link{nobs.dynamitefit}()}
}
\concept{output}
