% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dynamice.R
\name{dynamice}
\alias{dynamice}
\title{Estimate a Bayesian Dynamic Multivariate Panel Model With Multiple Imputation}
\usage{
dynamice(
  dformula,
  data,
  time,
  group = NULL,
  priors = NULL,
  backend = "rstan",
  verbose = TRUE,
  verbose_stan = FALSE,
  stanc_options = list("O0"),
  threads_per_chain = 1L,
  grainsize = NULL,
  custom_stan_model = NULL,
  debug = NULL,
  mice_args = list(),
  impute_format = "wide",
  keep_imputed = FALSE,
  stan_csv_dir = tempdir(),
  ...
)
}
\arguments{
\item{dformula}{[\code{dynamiteformula}]\cr The model formula.
See \code{\link[=dynamiteformula]{dynamiteformula()}} and 'Details'.}

\item{data}{[\code{data.frame}, \code{tibble::tibble}, or \code{data.table::data.table}]\cr
The data that contains the variables in the model in long format.
Supported column types are \code{integer}, \code{logical}, \code{double}, and
\code{factor}. Columns of type \code{character} will be converted to factors.
Unused factor levels will be dropped. The \code{data} can contain missing
values which will simply be ignored in the estimation in a case-wise
fashion (per time-point and per channel). Input \code{data} is converted to
channel specific matrix representations via \code{\link[stats:model.matrix]{stats::model.matrix.lm()}}.}

\item{time}{[\code{character(1)}]\cr A column name of \code{data} that denotes the
time index of observations. If this variable is a factor, the integer
representation of its levels are used internally for defining the time
indexing.}

\item{group}{[\code{character(1)}]\cr A column name of \code{data} that denotes the
unique groups or \code{NULL} corresponding to a scenario without any groups.
If \code{group} is \code{NULL}, a new column \code{.group} is created with constant
value \code{1L} is created indicating that all observations belong to the same
group. In case of name conflicts with \code{data}, see the \code{group_var} element
of the return object to get the column name of the new variable.}

\item{priors}{[\code{data.frame}]\cr An optional data frame with prior
definitions. See \code{\link[=get_priors]{get_priors()}} and 'Details'.}

\item{backend}{[\code{character(1)}]\cr Defines the backend interface to Stan,
should be  either \code{"rstan"} (the default) or \code{"cmdstanr"}. Note that
\code{cmdstanr} needs to be installed separately as it is not on CRAN. It also
needs the actual \code{CmdStan} software. See \url{https://mc-stan.org/cmdstanr/}
for details.}

\item{verbose}{[\code{logical(1)}]\cr All warnings and messages are suppressed
if set to \code{FALSE}. Defaults to \code{TRUE}. Setting this to \code{FALSE} will also
disable checks for perfect collinearity in the model matrix.}

\item{verbose_stan}{[\code{logical(1)}]\cr This is the \code{verbose} argument for
\code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}}. Defaults to \code{FALSE}.}

\item{stanc_options}{[\code{list()}]\cr This is the \code{stanc_options} argument
passed to the compile method of a \code{CmdStanModel} object via
\code{cmdstan_model()} when \code{backend = "cmdstanr"}. Defaults to \code{list("O0")}.
To enable level one compiler optimizations, use \code{list("O1")}.
See \url{https://mc-stan.org/cmdstanr/reference/cmdstan_model.html}
for details.}

\item{threads_per_chain}{[\code{integer(1)}]\cr A Positive integer defining the
number of parallel threads to use within each chain. Default is \code{1}. See
\code{\link[rstan:rstan_options]{rstan::rstan_options()}} and
\url{https://mc-stan.org/cmdstanr/reference/model-method-sample.html}
for details.}

\item{grainsize}{[\code{integer(1)}]\cr A positive integer defining the
suggested size of the partial sums when using within-chain parallelization.
Default is number of time points divided by \code{threads_per_chain}.
Setting this to \code{1} leads the workload division entirely to the internal
scheduler. The performance of the within-chain parallelization can be
sensitive to the choice of \code{grainsize}, see Stan manual on reduce-sum for
details.}

\item{custom_stan_model}{[\code{character(1)}]\cr An optional character string
that either contains a customized Stan model code or a path to a \code{.stan}
file that contains the code. Using this will override the generated model
code. For expert users only.}

\item{debug}{[\code{list()}]\cr A named list of form \code{name = TRUE} indicating
additional objects in the environment of the \code{dynamite} function which are
added to the return object. Additionally, values \code{no_compile = TRUE} and
\code{no_sampling = TRUE} can be used to skip the compilation of the Stan code
and sampling steps respectively. This can be useful for debugging when
combined with \code{model_code = TRUE}, which adds the Stan model code to the
return object.}

\item{mice_args}{[\code{list()}]\cr
Arguments passed to \code{\link[mice:mice]{mice::mice()}} excluding \code{data}.}

\item{impute_format}{[\code{character(1)}]\cr Format of the data that will be
passed to the imputation method. Should be either \code{"wide"} (the default)
or \code{"long"} corresponding to wide format and long format imputation.}

\item{keep_imputed}{[\code{logical(1)}]\cr Should the imputed datasets be
kept in the return object? The default is \code{FALSE}. If \code{TRUE}, the
imputations will be included in the \code{imputed} field in the return object
that is otherwise \code{NULL}.}

\item{stan_csv_dir}{[\code{character(1)}]\cr A directory path to output the
Stan .csv files when \code{backend} is \code{"cmdstanr"}. The files are saved here
via \verb{$save_output_files()} to avoid garbage collection between sampling
runs with different imputed datasets.}

\item{...}{For \code{dynamite()}, additional arguments to \code{\link[rstan:stanmodel-method-sampling]{rstan::sampling()}} or
the \verb{$sample()} method of the \code{CmdStanModel} object
(see \url{https://mc-stan.org/cmdstanr/reference/model-method-sample.html}),
such as \code{chains} and \code{cores}
(\code{chains} and \code{parallel_chains} in \code{cmdstanr}). For \code{summary()},
additional arguments to \code{\link[=as.data.frame.dynamitefit]{as.data.frame.dynamitefit()}}. For \code{print()},
further arguments to the print method for tibbles
(see \link[tibble:formatting]{tibble::formatting}). Not used for \code{formula()}.}
}
\description{
Applies multiple imputation using \code{\link[mice:mice]{mice::mice()}} to the supplied \code{data}
and fits a dynamic multivariate panel model to each imputed data set using
\code{\link[=dynamite]{dynamite()}}. Posterior samples from each imputation run are
combined. When using wide format imputation, the long format \code{data} is
automatically converted to a wide format before imputation to preserve the
longitudinal structure, and then converted back to long format for
estimation.
}
\seealso{
Model fitting
\code{\link{dynamite}()},
\code{\link{get_priors}()},
\code{\link{update.dynamitefit}()}
}
\concept{fitting}
