% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CornishFisher.R
\name{dCornishFisher}
\alias{dCornishFisher}
\alias{Cornish-Fisher}
\alias{pCornishFisher}
\alias{qCornishFisher}
\alias{rCornishFisher}
\title{Cornish-Fisher expansion}
\usage{
dCornishFisher(x, n, skew, ekurt)

pCornishFisher(q, n, skew, ekurt)

qCornishFisher(p, n, skew, ekurt)

rCornishFisher(n, sigma, skew, ekurt, dp = NULL, seed = NULL)
}
\arguments{
\item{x, q}{vector of standardized quantiles.}

\item{n}{scalar; number of simulated values in random simulation, sample 
length in density, distribution and quantile functions.}

\item{skew}{scalar; skewness.}

\item{ekurt}{scalar; excess kurtosis.}

\item{p}{vector of probabilities.}

\item{sigma}{scalar standard deviation.}

\item{dp}{a vector of length 3, whose elements represent sigma, skew and 
ekurt, respectively. If dp is specified, the individual parameters cannot be 
set. Default is \code{NULL}.}

\item{seed}{scalar; set seed. Default is \code{NULL}.}
}
\value{
\code{dCornishFisher} gives the density, \code{pCornishFisher} gives the 
distribution function, \code{qCornishFisher} gives the quantile function, 
and \code{rCornishFisher} generates \code{n} random simulations.
}
\description{
Density, distribution function, quantile function and random 
generation using Cornish-Fisher approximation.
}
\details{
CDF(q) = Pr(sqrt(n)*(x_bar-mu)/sigma < q)
\code{dCornishFisher} Computes Cornish-Fisher density from two term Edgeworth 
expansion given mean, standard deviation, skewness and excess kurtosis.
\code{pCornishFisher} Computes Cornish-Fisher CDF from two term Edgeworth 
expansion given mean, standard deviation, skewness and excess kurtosis.
\code{qCornishFisher} Computes Cornish-Fisher quantiles from two term 
Edgeworth expansion given mean, standard deviation, skewness and excess 
kurtosis.
\code{rCornishFisher} simulates observations based on Cornish-Fisher quantile 
expansion given mean, standard deviation, skewness and excess kurtosis.
}
\examples{
# generate 1000 observation from Cornish-Fisher distribution
rc <- rCornishFisher(1000,1,0,5)
hist(rc, breaks=100, freq=FALSE, 
     main="simulation of Cornish Fisher Distribution", xlim=c(-10,10))
lines(seq(-10,10,0.1), dnorm(seq(-10,10,0.1), mean=0, sd=1), col=2)
# compare with standard normal curve

# exponential example from A.dasGupta p.188
# x is iid exp(1) distribution, sample size = 5
# then x_bar is Gamma(shape=5, scale=1/5) distribution
q <- c(0,0.4,1,2)
# exact cdf
pgamma(q/sqrt(5)+1, shape=5, scale=1/5)
# use CLT
pnorm(q)
# use edgeworth expansion
pCornishFisher(q, n=5, skew=2, ekurt=6)

}
\references{
DasGupta, A. (2008). Asymptotic theory of statistics and probability. 
Springer.
Severini, T. A., (2000). Likelihood Methods in Statistics. Oxford University 
Press.
}
\author{
Eric Zivot and Yi-An Chen.
}
