% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/makefastcmhdata.R
\name{makefastcmhdata}
\alias{makefastcmhdata}
\title{Create sample data for fastcmh}
\usage{
makefastcmhdata(folder = "./", xfilename = "data.txt",
  yfilename = "label.txt", covfilename = "cov.txt", K = 2, L = 1000,
  n = 200, noiseP = 0.3, corruptP = 0.05, rho = 0.8, tau1 = 100,
  taulength1 = 4, tau2 = 200, taulength2 = 4, seednum = 2,
  truetaufilename = "truetau.txt", showOutput = FALSE, saveToList = FALSE)
}
\arguments{
\item{folder}{The folder in which the data will be saved. Default is
current directory \code{"./"}.}

\item{xfilename}{The name of the data file. Default is \code{"data.txt"}}

\item{yfilename}{The name of the label file. Default is \code{"label.txt"}}

\item{covfilename}{The name of the file containing the covariate categories
. This file actually just contains \code{K} numbers, where \code{K} is the
number of covariates. Default is \code{"cov.txt"}}

\item{K}{The number of covariates (a positive integer). Default is
\code{K=2}.}

\item{L}{The number of features (length of each sequence). Default is
\code{L=1000}.}

\item{n}{The number of samples (cases and controls combined). Default is
\code{n=200}, i.e. 100 cases and 100 controls.}

\item{noiseP}{The background noise in the data (as a probability of 0/1
being flipped). Default is \code{noiseP=0.3}}

\item{corruptP}{The probability of data corruption: each bit has
probability \code{corruptP} of being flipped. Default is
\code{corruptP=0.05}.}

\item{rho}{The strength of the confounding in the confounded interval (as
a probability). Default is \code{rho=0.8} (i.e. a very strong signal).}

\item{tau1}{The location of the significant interval (starting point).
Default value is \code{tau1=100}.}

\item{taulength1}{The length of the significant interval. Default value is
\code{taulength1=4}, so default significant interval is \code{[100, 103]}.}

\item{tau2}{The location of the confounded significant interval (starting
point). Default value is \code{tau2=200}.}

\item{taulength2}{The length of the confounded significant interval.
Default value is \code{taulength2=4}, so default significant interval is
\code{[200, 203]}.}

\item{seednum}{The seed used for generating the data. Default value is
\code{seednum=2}.}

\item{truetaufilename}{The file where the location of the true significant
intervals are saved (as opposed to the detected significant intervals).
Default is \code{"truetau.txt"}.}

\item{showOutput}{Flag to decide whether or not to show output, where files
are created, their names, etc. Default is \code{FALSE}, so will save to
\code{folder} by default. However, all of the examples use
\code{saveToList=TRUE} in order to avoid writing to file. The list will
consist of \code{data}, \code{label} and \code{cov} data frames, when
\code{saveToList=TRUE}.}

\item{saveToList}{Flag to decide whether or not to save data to the folder,
or to return (output) the data as a list. By default,
\code{saveToList=FALSE}.}
}
\description{
This function creates sample data for use with the \code{runfastcmh} method.
}
\section{See Also}{

\code{\link{runfastcmh}}
}
\examples{
#make a small sample data set, using the default parameters
mylist <- makefastcmhdata(showOutput=TRUE, saveToList=TRUE)

#make a very small sample data set
mylist <- makefastcmhdata(n=20, L=10, tau1=2, taulength1=2,
       tau2=6, taulength2=2, saveToList=TRUE)
}

