% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PredictorCaret.R
\name{PredictorCaret}
\alias{PredictorCaret}
\title{PredictorCaret}
\description{
This task specializes \link{Predictor} for \code{caret} regression models.
The \code{model} is assumed to be a \code{c("train", "train.formula")}.

It is recommended to use \code{\link[=makePredictor]{makePredictor()}} for construction of Predictor objects.
}
\section{Super class}{
\code{\link[fmeffects:Predictor]{fmeffects::Predictor}} -> \code{PredictorCaret}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PredictorCaret-new}{\code{PredictorCaret$new()}}
\item \href{#method-PredictorCaret-predict}{\code{PredictorCaret$predict()}}
\item \href{#method-PredictorCaret-clone}{\code{PredictorCaret$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictorCaret-new"></a>}}
\if{latex}{\out{\hypertarget{method-PredictorCaret-new}{}}}
\subsection{Method \code{new()}}{
Create a new PredictorCaret object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictorCaret$new(model, data, target)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{model}}{\verb{train, train.formula} object.}

\item{\code{data}}{The data used for computing FMEs, must be data.frame or data.table.}

\item{\code{target}}{A string specifying the target variable.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictorCaret-predict"></a>}}
\if{latex}{\out{\hypertarget{method-PredictorCaret-predict}{}}}
\subsection{Method \code{predict()}}{
Predicts on an observation \code{"newdata"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictorCaret$predict(newdata)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{newdata}}{The feature vector for which the target should be predicted.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PredictorCaret-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PredictorCaret-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PredictorCaret$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
