% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix_form.R
\name{MatrixPrintForm}
\alias{MatrixPrintForm}
\alias{MatrixPrintForm-class}
\alias{matrix_print_form}
\title{Matrix Print Form - Intermediate Representation for ASCII Table Printing}
\usage{
MatrixPrintForm(
  strings = NULL,
  spans,
  aligns,
  formats,
  row_info,
  line_grouping = seq_len(NROW(strings)),
  ref_fnotes = list(),
  nlines_header,
  nrow_header,
  has_topleft = TRUE,
  has_rowlabs = has_topleft,
  expand_newlines = TRUE,
  main_title = "",
  subtitles = character(),
  page_titles = character(),
  main_footer = "",
  prov_footer = character(),
  col_gap = 3,
  table_inset = 0L
)

matrix_print_form(
  strings = NULL,
  spans,
  aligns,
  formats,
  row_info,
  line_grouping = seq_len(NROW(strings)),
  ref_fnotes = list(),
  nlines_header,
  nrow_header,
  has_topleft = TRUE,
  has_rowlabs = has_topleft,
  expand_newlines = TRUE,
  main_title = "",
  subtitles = character(),
  page_titles = character(),
  main_footer = "",
  prov_footer = character(),
  col_gap = 3,
  table_inset = 0L
)
}
\arguments{
\item{strings}{character  matrix.  Matrix  of formatted,  ready to
display  strings  organized as  they  will  be positioned  when
rendered.   Elements that  span more  than one  column must  be
followed  by  the  correct number  of  placeholders  (typically
either empty strings or repeats of the value).}

\item{spans}{numeric  matrix.    Matrix  of  same  dimension  as
\code{strings}  giving   the  spanning  information   for  each
element.    Must  be   repeated   to   match  placeholders   in
\code{strings}.}

\item{aligns}{character  matrix.   Matrix  of same  dimension  as
\code{strings} giving  the text alignment information  for each
element.    Must  be   repeated   to   match  placeholders   in
\code{strings}.}

\item{formats}{matrix. Matrix  of same dimension
as  \code{strings} giving  the text  format information  for
each  element.   Must  be  repeated to  match  placeholders  in
\code{strings}.}

\item{row_info}{data.frame.   Data.frame  with  row-information
necessary for pagination (XXX document exactly what that is).}

\item{line_grouping}{integer. Sequence of  integers indicating how
print  lines  correspond  to   semantic  rows  in  the  object.
Typically   this   should   not    be   set   manually   unless
expact_newlines is set to \code{FALSE}.}

\item{ref_fnotes}{list.   Referential  footnote  information  if
applicable.}

\item{nlines_header}{numeric(1). Number  of lines taken up  by the
values of the header (ie not including the divider).}

\item{nrow_header}{numeric(1).  Number of \emph{rows} corresponding
to the header.}

\item{has_topleft}{logical(1).  Does the  corresponding table have
'top left information' which should be treated differently when
expanding  newlines.   Ignored   if  \code{expand_newlines}  is
\code{FALSE}.}

\item{has_rowlabs}{logical(1). Do  the matrices  (\code{strings},
\code{spans},  \code{aligns})   each  contain  a   column  that
corresponds  with  row  labels  (Rather than  with  table  cell
values).  Defaults to \code{TRUE}.}

\item{expand_newlines}{logical(1). Should the matrix form generated
expand  rows  whose  values   contain  newlines  into  multiple
'physical'  rows  (as  they  will  appear  when  rendered  into
ASCII). Defaults to \code{TRUE}}

\item{main_title}{character(1). Main title as a string.}

\item{subtitles}{character. Subtitles, as a character vector.}

\item{page_titles}{character.  Page-specific titles, as a character
vector.}

\item{main_footer}{character(1). Main footer as a string.}

\item{prov_footer}{character.  Provenance footer  information as a
character vector.}

\item{col_gap}{numeric(1). Space (in characters) between columns}

\item{table_inset}{numeric(1). Table inset. See
\code{\link{table_inset}}}
}
\value{
An object of class `MatrixPrintForm`. Currently this is
implemented as an S3 class inheriting from list with the following
elements:
\describe{
\item{\code{strings}}{see argument}
\item{\code{spans}}{see argument}
\item{\code{aligns}}{see argument}
\item{\code{display}}{logical matrix of same dimension as `strings`
that specifies whether an element in `strings` will be displayed
when the table is rendered}
\item{\code{formats}}{see arugment}
\item{\code{row_info}}{see argument}
\item{\code{line_grouping}}{see argument}
\item{\code{ref_footnotes}}{see argument}
\item{\code{main_title}}{see argument}
\item{\code{subtitles}}{see argument}
\item{\code{page_titles}}{see argument}
\item{\code{main_footer}}{see argument}
\item{\code{prov_footer}}{see argument}
\item{\code{col_gap}}{see argument}
\item{\code{table_inset}}{see argument}
}

as well as the following attributes:
\describe{
\item{\code{nlines_header}}{see argument}
\item{\code{nrow_header}}{see argument}
\item{\code{ncols}}{number of columns \emph{of the table}, not including
any row names/row labels}
}
}
\description{
This should generally only be called by `matrix_form` custom
methods, and almost never from other code.
}
