% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpf_exporters.R
\name{export_as_txt}
\alias{export_as_txt}
\title{Export a table-like object to plain (ASCII) text with page break}
\usage{
export_as_txt(
  x,
  file = NULL,
  page_type = NULL,
  landscape = FALSE,
  pg_width = page_dim(page_type)[if (landscape) 2 else 1],
  pg_height = page_dim(page_type)[if (landscape) 1 else 2],
  font_family = "Courier",
  font_size = 8,
  lineheight = 1L,
  margins = c(top = 0.5, bottom = 0.5, left = 0.75, right = 0.75),
  paginate = TRUE,
  cpp = NA_integer_,
  lpp = NA_integer_,
  ...,
  hsep = default_hsep(),
  indent_size = 2,
  tf_wrap = paginate,
  max_width = NULL,
  colwidths = NULL,
  min_siblings = 2,
  nosplitin = character(),
  rep_cols = num_rep_cols(x),
  verbose = FALSE,
  page_break = "\\\\s\\\\n"
)
}
\arguments{
\item{x}{ANY.  The  table-like object  to  export.  Must have  an
applicable \code{matrix_form} method.}

\item{file}{character(1) or NULL.  If non-NULL, the path to write a
text file to containing the \code{x} rendered as ASCII text,}

\item{page_type}{character(1).   Name   of  a  page  type.   See
\code{page_types}.   Ignored when  \code{pg_width} and  \code{pg_height}
are set directly.}

\item{landscape}{logical(1). Should the  dimensions of \code{page_type}
be inverted  for landscape?  Defaults to  \code{FALSE}, ignored when
\code{pg_width} and \code{pg_height} are set directly.}

\item{pg_width}{numeric(1). Page width in inches.}

\item{pg_height}{numeric(1). Page height in inches.}

\item{font_family}{character(1). Name of a font family. An error
will be thrown if the family named is not monospaced. Defaults
to Courier.}

\item{font_size}{numeric(1). Font size, defaults to 12.}

\item{lineheight}{numeric(1). Line height, defaults to 1.}

\item{margins}{numeric(4). Named numeric vector containing \code{'bottom'},
\code{'left'}, \code{'top'}, and \code{'right'} margins in inches. Defaults
to \code{.5} inches for both vertical margins and \code{.75} for both
horizontal margins.}

\item{paginate}{logical(1). Whether pagination should be performed,
defaults to \code{TRUE} if page size is specified (including
the default).}

\item{cpp}{numeric(1) or NULL. Width in characters per page. if NA (the default,
this is calculated automatically based on the specified page
size). \code{NULL} indicates no horizontal pagination should occur.}

\item{lpp}{numeric(1) or NULL. Lines per page. if NA (the default,
this is calculated automatically based on the specified page
size). \code{NULL} indicates no vertical pagination should occur.}

\item{...}{Passed to individual methods.}

\item{hsep}{character(1).   Characters  to  repeat   to  create
header/body separator line.}

\item{indent_size}{numeric(1). Indent size in characters. Ignored
when \code{x} is already a MatrixPrintForm object in favor of information
there.}

\item{tf_wrap}{logical(1). Should  the texts for  title, subtitle,
and footnotes be wrapped?}

\item{max_width}{integer(1), character(1) or NULL. Width that title
and   footer   (including   footnotes)  materials   should   be
word-wrapped to. If NULL, it is  set to the current print width
of the  session (\code{getOption("width")}). If set to \code{"auto"},
the width of the table (plus any table inset) is used. Ignored
completely if \code{tf_wrap} is \code{FALSE}.}

\item{colwidths}{numeric vector.  Column widths (in characters) for
use with vertical pagination.}

\item{min_siblings}{numeric. Minimum sibling rows which must appear on either side of pagination row for a
mid-subtable split to be valid. Defaults to 2.}

\item{nosplitin}{character. List of names of sub-tables where page-breaks are not allowed, regardless of other
considerations. Defaults to none.}

\item{rep_cols}{numeric(1). Number of \emph{columns} (not including
row labels) to be repeated on every page. Defaults to 0}

\item{verbose}{logical(1). Should additional informative messages about the search for
pagination breaks be shown. Defaults to \code{FALSE}.}

\item{page_break}{character(1).  Page break  symbol (defaults  to
outputting \code{"\\n\\s"}).}
}
\value{
if \code{file} is NULL, the total paginated and then concatenated
string value, otherwise the file that was written.
}
\description{
This function converts \code{x} to a \code{MatrixPrintForm} object via
\code{matrix_form}, paginates it via \code{paginate}, converts each
page to ASCII text via \code{toString}, and emits the strings to \code{file},
separated by \code{page_break}.
}
\details{
if  \code{x} has an \code{num_rep_cols}  method, the value
returned by it will be  used for \code{rep_cols} by default, if
not, 0 will be used.

If \code{x} has an applicable \code{do_mand_paginate} method, it will be invoked
during the pagination process.
}
\examples{
export_as_txt(basic_matrix_form(mtcars), pg_height = 5, pg_width = 4)
}
