% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tostring.R
\name{padstr}
\alias{padstr}
\title{Pad a string and align within string}
\usage{
padstr(x, n, just = list_valid_aligns())
}
\arguments{
\item{x}{string}

\item{n}{number  of  character  of the  output  string,  if \code{n  < nchar(x)} an error is thrown}

\item{just}{character(1).   Text  alignment   justification  to
use. Defaults to \code{center}. Must be \code{center}, \code{right}, \code{left},
\code{dec_right}, \code{dec_left} or \code{decimal}.}
}
\value{
\code{x}, padded to be a string of \code{n} characters
}
\description{
Pad a string and align within string
}
\examples{

padstr("abc", 3)
padstr("abc", 4)
padstr("abc", 5)
padstr("abc", 5, "left")
padstr("abc", 5, "right")

if (interactive()) {
  padstr("abc", 1)
}
}
