% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mpf_exporters.R
\name{mpf_to_rtf}
\alias{mpf_to_rtf}
\title{Transform \code{MatrixPrintForm} to RTF}
\usage{
mpf_to_rtf(
  mpf,
  colwidths = NULL,
  page_type = "letter",
  pg_width = page_dim(page_type)[if (landscape) 2 else 1],
  pg_height = page_dim(page_type)[if (landscape) 1 else 2],
  landscape = FALSE,
  margins = c(4, 4, 4, 4),
  font_size = 8,
  ...
)
}
\arguments{
\item{mpf}{(\code{MatrixPrintForm})\cr a \code{MatrixPrintForm} object.}

\item{colwidths}{(\code{numeric})\cr column widths.}

\item{page_type}{(\code{string})\cr name of a page type. See \code{\link{page_types}}. Ignored
when \code{pg_width} and \code{pg_height} are set directly.}

\item{pg_width}{(\code{numeric(1)})\cr page width in inches.}

\item{pg_height}{(\code{numeric(1)})\cr page height in inches.}

\item{landscape}{(\code{flag})\cr whether the dimensions of \code{page_type} should be
inverted for landscape orientation. Defaults to \code{FALSE}, ignored when \code{pg_width} and
\code{pg_height} are set directly.}

\item{margins}{(\code{numeric(4)})\cr named numeric vector containing \code{"bottom"}, \code{"left"},
\code{"top"}, and \code{"right"} margins in inches. Defaults to \code{.5} inches for both vertical
margins and \code{.75} for both horizontal margins.}

\item{font_size}{(\code{numeric(1)})\cr font size. Defaults to \code{12}.}

\item{...}{additional parameters passed to individual methods.}
}
\value{
An RTF object.
}
\description{
Experimental export to rich text format (RTF) via the \code{r2rtf} package.
}
\details{
This function provides a low-level coercion of a \code{MatrixPrintForm} object into
text containing the corresponding table in RTF. Currently, no pagination is done
at this level, and should be done prior to calling this function, though that
may change in the future.
}
