% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.fwelnet.R
\name{cv.fwelnet}
\alias{cv.fwelnet}
\title{Cross-validation for fwelnet}
\usage{
cv.fwelnet(
  x,
  y,
  z,
  family = c("gaussian", "binomial"),
  lambda = NULL,
  type.measure = c("mse", "deviance", "class", "auc", "mae"),
  nfolds = 10,
  foldid = NULL,
  keep = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{\code{x} matrix as in \code{fwelnet}.}

\item{y}{\code{y} matrix as in \code{fwelnet}.}

\item{z}{\code{z} matrix as in \code{fwelnet}.}

\item{family}{Response type. Either \code{"gaussian"} (default) for linear
regression or \code{"binomial"} for logistic regression.}

\item{lambda}{A user supplied \code{lambda} sequence. Typical usage is to
have the program compute its own \code{lambda} sequence; supplying a value of
lambda overrides this.}

\item{type.measure}{Loss to use for cross-validation. Currently five options,
not all available for all models. The default is type.measure="deviance",
which uses squared-error for gaussian models (a.k.a type.measure="mse" there)
and deviance for logistic regression. type.measure="class" applies to binomial
logistic regression only, and gives misclassification error. type.measure="auc"
is for two-class logistic regression only, and gives area under the ROC curve.
type.measure="mse" or type.measure="mae" (mean absolute error) can be used by
all models.}

\item{nfolds}{Number of folds for CV (default is 10). Although \code{nfolds}
can be as large as the sample size (leave-one-out CV), it is not recommended
for large datasets. Smallest value allowable is \code{nfolds = 3}.}

\item{foldid}{An optional vector of values between 1 and \code{nfolds}
identifying what fold each observation is in. If supplied, \code{nfolds} can
be missing.}

\item{keep}{If \code{keep = TRUE}, a prevalidated array is returned
containing fitted values for each observation at each value of lambda. This
means these fits are computed with this observation and the rest of its fold
omitted. Default is \code{FALSE}.}

\item{verbose}{Print information as model is being fit? Default is FALSE.}

\item{...}{Other arguments that can be passed to \code{fwelnet}.}
}
\value{
An object of class \code{"cv.fwelnet"}, which is a list with the
ingredients of the cross-validation fit.
\item{glmfit}{A fitted \code{fwelnet} object for the full data.}
\item{lambda}{The values of \code{lambda} used in the fits.}
\item{nzero}{The number of non-zero coefficients in the model \code{glmfit}.}
\item{fit.preval}{If \code{keep=TRUE}, this is the array of prevalidated
  fits.}
\item{cvm}{The mean cross-validated error: a vector of length
  \code{length(lambda)}.}
\item{cvsd}{Estimate of standard error of \code{cvm}.}
\item{cvlo}{Lower curve = \code{cvm - cvsd}.}
\item{cvup}{Upper curve = \code{cvm + cvsd}.}
\item{lambda.min}{The value of \code{lambda} that gives minimum
  \code{cvm}.}
\item{lambda.1se}{The largest value of \code{lambda} such that the CV
  error is within one standard error of the minimum.}
\item{foldid}{If \code{keep=TRUE}, the fold assignments used.}
\item{name}{Name of error measurement used for CV.}
\item{call}{The call that produced this object.}
}
\description{
Does \code{k}-fold cross-validation for \code{fwelnet}.
}
\details{
This function runs \code{fwelnet nfolds+1} times: the first to get the
\code{lambda} sequence, and the remaining \code{nfolds} times to compute the
fit with each of the folds omitted. The error is accumulated, and the mean
error and standard deviation over the folds is computed. Note that
\code{cv.pcLasso} does NOT search for values of \code{alpha}. A specific
value of \code{alpha} should be supplied.
}
\examples{
set.seed(1)
n <- 100; p <- 20
x <- matrix(rnorm(n * p), n, p)
beta <- matrix(c(rep(2, 5), rep(0, 15)), ncol = 1)
y <- x \%*\% beta + rnorm(n)
z <- cbind(1, abs(beta) + rnorm(p))

cvfit1 <- cv.fwelnet(x, y, z)

# change no. of CV folds
cvfit2 <- cv.fwelnet(x, y, z, nfolds = 5)
# specify which observations are in each fold
foldid <- sample(rep(seq(5), length = length(y)))
cvfit3 <- cv.fwelnet(x, y, z, foldid = foldid)
# keep=TRUE to have pre-validated fits and foldid returned
cvfit4 <- cv.fwelnet(x, y, z, keep = TRUE)

}
