% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_slab.R
\name{geom_slab}
\alias{geom_slab}
\title{Slab (ridge) plot (shortcut geom)}
\usage{
geom_slab(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  orientation = NA,
  normalize = "all",
  fill_type = "segments",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string, or the result of a call to a position adjustment function.
Setting this equal to \code{"dodge"} (\code{\link[=position_dodge]{position_dodge()}}) or \code{"dodgejust"} (\code{\link[=position_dodgejust]{position_dodgejust()}}) can be useful if
you have overlapping geometries.}

\item{...}{Other arguments passed to \code{\link[=layer]{layer()}}. These are often aesthetics, used to set an aesthetic
to a fixed value, like \code{colour = "red"} or \code{linewidth = 3} (see \strong{Aesthetics}, below). They may also be
parameters to the paired geom/stat.}

\item{orientation}{Whether this geom is drawn horizontally or vertically. One of:
\itemize{
\item \code{NA} (default): automatically detect the orientation based on how the aesthetics
are assigned. Automatic detection works most of the time.
\item \code{"horizontal"} (or \code{"y"}): draw horizontally, using the \code{y} aesthetic to identify different
groups. For each group, uses the \code{x}, \code{xmin}, \code{xmax}, and \code{thickness} aesthetics to
draw points, intervals, and slabs.
\item \code{"vertical"} (or \code{"x"}): draw vertically, using the \code{x} aesthetic to identify different
groups. For each group, uses the \code{y}, \code{ymin}, \code{ymax}, and \code{thickness} aesthetics to
draw points, intervals, and slabs.
}
For compatibility with the base ggplot naming scheme for \code{orientation}, \code{"x"} can be used as an alias
for \code{"vertical"} and \code{"y"} as an alias for \code{"horizontal"} (\pkg{ggdist} had an \code{orientation} parameter
before base ggplot did, hence the discrepancy).}

\item{normalize}{How to normalize heights of functions input to the \code{thickness} aesthetic. One of:
\itemize{
\item \code{"all"}: normalize so that the maximum height across all data is \code{1}.
\item \code{"panels"}: normalize within panels so that the maximum height in each panel is \code{1}.
\item \code{"xy"}: normalize within the x/y axis opposite the \code{orientation} of this geom so
that the maximum height at each value of the opposite axis is \code{1}.
\item \code{"groups"}: normalize within values of the opposite axis and within each
group so that the maximum height in each group is \code{1}.
\item \code{"none"}: values are taken as is with no normalization (this should probably
only be used with functions whose values are in [0,1], such as CDFs).
}}

\item{fill_type}{What type of fill to use when the fill color or alpha varies within a slab. One of:
\itemize{
\item \code{"segments"}: breaks up the slab geometry into segments for each unique combination of fill color and
alpha value. This approach is supported by all graphics devices and works well for sharp cutoff values,
but can give ugly results if a large number of unique fill colors are being used (as in gradients,
like in \code{\link[=stat_gradientinterval]{stat_gradientinterval()}}).
\item \code{"gradient"}: a \code{grid::linearGradient()} is used to create a smooth gradient fill. This works well for
large numbers of unique fill colors, but requires R >= 4.1 and is not yet supported on all graphics devices.
As of this writing, the \code{png()} graphics device with \code{type = "cairo"}, the \code{svg()} device, the \code{pdf()}
device, and the \code{ragg::agg_png()} devices are known to support this option. On R < 4.1, this option
will fall back to \code{fill_type = "segment"} with a message.
\item \code{"auto"}: attempts to use \code{fill_type = "gradient"} if support for it can be auto-detected. On R >= 4.2,
support for gradients can be auto-detected on some graphics devices; if support is not detected, this
option will fall back to \code{fill_type = "segments"} (in case of a false negative, \code{fill_type = "gradient"}
can be set explicitly). On R < 4.2, support for gradients cannot be auto-detected, so this will always
fall back to \code{fill_type = "segments"}, in which case you can set \code{fill_type = "gradient"} explicitly
if you are using a graphics device that support gradients.
}}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with a warning. If \code{TRUE}, missing
values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Geom} representing a slab (ridge) geometry which can
be added to a \code{\link[=ggplot]{ggplot()}} object.
}
\description{
Shortcut version of \code{\link[=geom_slabinterval]{geom_slabinterval()}} for creating slab (ridge) plots.

Roughly equivalent to:

\if{html}{\out{<div class="sourceCode">}}\preformatted{geom_slabinterval(
  show_point = FALSE, show_interval = FALSE
)
}\if{html}{\out{</div>}}
}
\section{Aesthetics}{

The slab+interval \code{stat}s and \code{geom}s have a wide variety of aesthetics that control
the appearance of their three sub-geometries: the \strong{slab}, the \strong{point}, and
the \strong{interval}.

\strong{Positional aesthetics}

\itemize{
\item{\code{x}: x position of the geometry}
\item{\code{y}: y position of the geometry}
}

\strong{Slab-specific aesthetics}

\itemize{
\item{\code{thickness}: The thickness of the slab at each \code{x} value (if \code{orientation = "horizontal"}) or
\code{y} value (if \code{orientation = "vertical"}) of the slab.}
\item{\code{side}: Which side to place the slab on. \code{"topright"}, \code{"top"}, and \code{"right"} are synonyms
which cause the slab to be drawn on the top or the right depending on if \code{orientation} is \code{"horizontal"}
or \code{"vertical"}. \code{"bottomleft"}, \code{"bottom"}, and \code{"left"} are synonyms which cause the slab
to be drawn on the bottom or the left depending on if \code{orientation} is \code{"horizontal"} or
\code{"vertical"}. \code{"topleft"} causes the slab to be drawn on the top or the left, and \code{"bottomright"}
causes the slab to be drawn on the bottom or the right. \code{"both"} draws the slab mirrored on both
sides (as in a violin plot).}
\item{\code{scale}: What proportion of the region allocated to this geom to use to draw the slab. If \code{scale = 1},
slabs that use the maximum range will just touch each other. Default is \code{0.9} to leave some space.}
\item{\code{justification}: Justification of the interval relative to the slab, where \code{0} indicates bottom/left
justification and \code{1} indicates top/right justification (depending on \code{orientation}). If \code{justification}
is \code{NULL} (the default), then it is set automatically based on the value of \code{side}: when \code{side} is
\code{"top"}/\code{"right"} \code{justification} is set to \code{0}, when \code{side} is \code{"bottom"}/\code{"left"}
\code{justification} is set to \code{1}, and when \code{side} is \code{"both"} \code{justification} is set to 0.5.}
}

\strong{Color aesthetics}

\itemize{
\item{\code{colour}: (or \code{color}) The color of the \strong{interval} and \strong{point} sub-geometries.
Use the \code{slab_color}, \code{interval_color}, or \code{point_color} aesthetics (below) to
set sub-geometry colors separately.}
\item{\code{fill}: The fill color of the \strong{slab} and \strong{point} sub-geometries. Use the \code{slab_fill}
or \code{point_fill} aesthetics (below) to set sub-geometry colors separately.}
\item{\code{alpha}: The opacity of the \strong{slab}, \strong{interval}, and \strong{point} sub-geometries. Use the \code{slab_alpha},
\code{interval_alpha}, or \code{point_alpha} aesthetics (below) to set sub-geometry colors separately.}
\item{\code{colour_ramp}: (or \code{color_ramp}) A secondary scale that modifies the \code{color}
scale to "ramp" to another color. See \code{\link[=scale_colour_ramp]{scale_colour_ramp()}} for examples.}
\item{\code{fill_ramp}: A secondary scale that modifies the \code{fill}
scale to "ramp" to another color. See \code{\link[=scale_fill_ramp]{scale_fill_ramp()}} for examples.}
}

\strong{Line aesthetics}

\itemize{
\item{\code{linewidth}: Width of the line used to draw the \strong{interval} (except with \code{\link[=geom_slab]{geom_slab()}}: then
it is the width of the \strong{slab}). With composite geometries including an interval and slab,
use \code{slab_linewidth} to set the line width of the \strong{slab} (see below). For \strong{interval}, raw
\code{linewidth} values are transformed according to the \code{interval_size_domain} and \code{interval_size_range}
parameters of the \code{geom} (see above).}
\item{\code{size}: Determines the size of the \strong{point}. If \code{linewidth} is not provided, \code{size} will
also determines the width of the line used to draw the \strong{interval} (this allows line width and
point size to be modified together by setting only \code{size} and not \code{linewidth}). Raw
\code{size} values are transformed according to the \code{interval_size_domain}, \code{interval_size_range},
and \code{fatten_point} parameters of the \code{geom} (see above). Use the \code{point_size} aesthetic
(below) to set sub-geometry size directly without applying the effects of
\code{interval_size_domain}, \code{interval_size_range}, and \code{fatten_point}.}
\item{\code{stroke}: Width of the outline around the \strong{point} sub-geometry.}
\item{\code{linetype}: Type of line (e.g., \code{"solid"}, \code{"dashed"}, etc) used to draw the \strong{interval}
and the outline of the \strong{slab} (if it is visible). Use the \code{slab_linetype} or
\code{interval_linetype} aesthetics (below) to set sub-geometry line types separately.}
}

\strong{Slab-specific color/line override aesthetics}

\itemize{
\item{\code{slab_fill}: Override for \code{fill}: the fill color of the slab.}
\item{\code{slab_colour}: (or \code{slab_color}) Override for \code{colour}/\code{color}: the outline color of the slab.}
\item{\code{slab_alpha}: Override for \code{alpha}: the opacity of the slab.}
\item{\code{slab_linewidth}: Override for \code{linwidth}: the width of the outline of the slab.}
\item{\code{slab_linetype}: Override for \code{linetype}: the line type of the outline of the slab.}
}

\strong{Deprecated aesthetics}

\itemize{
\item{\code{slab_size}: Use \code{slab_linewidth}.}
}

\strong{Other aesthetics} (these work as in standard \code{geom}s)

\itemize{
\item{\code{width}}
\item{\code{height}}
\item{\code{group}}
}

See examples of some of these aesthetics in action in \code{vignette("slabinterval")}.
Learn more about the sub-geom override aesthetics (like \code{interval_color}) in the
\link[ggdist]{scales} documentation. Learn more about basic ggplot aesthetics in
\code{vignette("ggplot2-specs")}.
}

\examples{

library(dplyr)
library(ggplot2)

theme_set(theme_ggdist())

# we will manually demonstrate plotting a density with geom_slab(),
# though generally speaking this is easier to do using stat_slab(), which
# will determine sensible limits automatically and correctly adjust
# densities when using scale transformations
df = expand.grid(
    mean = 1:3,
    input = seq(-2, 6, length.out = 100)
  ) \%>\%
  mutate(
    group = letters[4 - mean],
    density = dnorm(input, mean, 1)
  )

# orientation is detected automatically based on
# use of x or y
df \%>\%
  ggplot(aes(y = group, x = input, thickness = density)) +
  geom_slab()

df \%>\%
  ggplot(aes(x = group, y = input, thickness = density)) +
  geom_slab()

# RIDGE PLOTS
# "ridge" plots can be created by increasing the slab height and
# setting the slab color
df \%>\%
  ggplot(aes(y = group, x = input, thickness = density)) +
  geom_slab(height = 2, color = "black")

}
\seealso{
See \code{\link[=stat_slab]{stat_slab()}} for the stat version, intended for
use on sample data or analytical distributions.
See \code{\link[=geom_slabinterval]{geom_slabinterval()}} for the geometry this shortcut is based on.

Other slabinterval geoms: 
\code{\link{geom_interval}()},
\code{\link{geom_pointinterval}()}
}
\concept{slabinterval geoms}
