% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/disks.R
\name{gce_make_disk}
\alias{gce_make_disk}
\title{Creates a persistent disk in the specified project using the data in the request.}
\usage{
gce_make_disk(
  name,
  sourceImage = NULL,
  sizeGb = NULL,
  description = NULL,
  diskEncryptionKey = NULL,
  licenses = NULL,
  sourceSnapshot = NULL,
  sourceImageEncryptionKey = NULL,
  sourceSnapshotEncryptionKey = NULL,
  type = NULL,
  project = gce_get_global_project(),
  zone = gce_get_global_zone()
)
}
\arguments{
\item{name}{Name of the resource}

\item{sourceImage}{The source image used to create this disk}

\item{sizeGb}{Size of the persistent disk, specified in GB}

\item{description}{An optional description of this resource}

\item{diskEncryptionKey}{Encrypts the disk using a customer-supplied encryption key}

\item{licenses}{Any applicable publicly visible licenses}

\item{sourceSnapshot}{The source snapshot used to create this disk}

\item{sourceImageEncryptionKey}{The customer-supplied encryption key of the source image}

\item{sourceSnapshotEncryptionKey}{The customer-supplied encryption key of the source snapshot}

\item{type}{URL of the disk type resource describing which disk type to use to create the disk}

\item{project}{Project ID for this request}

\item{zone}{The name of the zone for this request}
}
\value{
a zone operation
}
\description{
You can create a disk with a sourceImage, a sourceSnapshot, or create an empty 500 GB data disk by omitting all properties.
}
\details{
You can also create a disk that is larger than the default size by specifying the sizeGb property.


Authentication scopes used by this function are:
\itemize{
  \item https://www.googleapis.com/auth/cloud-platform
\item https://www.googleapis.com/auth/compute
}
}
\seealso{
\href{https://developers.google.com/compute/docs/reference/latest/}{Google Documentation}
}
