% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resp-stream.R
\name{resp_stream_raw}
\alias{resp_stream_raw}
\alias{resp_stream_lines}
\alias{resp_stream_sse}
\alias{close.httr2_response}
\title{Read a streaming body a chunk at a time}
\usage{
resp_stream_raw(resp, kb = 32)

resp_stream_lines(resp, lines = 1, max_size = Inf, warn = TRUE)

resp_stream_sse(resp, max_size = Inf)

\method{close}{httr2_response}(con, ...)
}
\arguments{
\item{resp, con}{A streaming \link{response} created by \code{\link[=req_perform_connection]{req_perform_connection()}}.}

\item{kb}{How many kilobytes (1024 bytes) of data to read.}

\item{lines}{The maximum number of lines to return at once.}

\item{max_size}{The maximum number of bytes to buffer; once this number of
bytes has been exceeded without a line/event boundary, an error is thrown.}

\item{warn}{Like \code{\link[=readLines]{readLines()}}: warn if the connection ends without a final
EOL.}

\item{...}{Not used; included for compatibility with generic.}
}
\value{
\itemize{
\item \code{resp_stream_raw()}: a raw vector.
\item \code{resp_stream_lines()}: a character vector.
\item \code{resp_stream_sse()}: a list with components \code{type}, \code{data}, and \code{id}; or
\code{NULL}, signifying that the end of the stream has been reached or--if in
nonblocking mode--that no event is currently available.
}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
\itemize{
\item \code{resp_stream_raw()} retrieves bytes (\code{raw} vectors).
\item \code{resp_stream_lines()} retrieves lines of text (\code{character} vectors).
\item \code{resp_stream_sse()} retrieves \href{https://developer.mozilla.org/en-US/docs/Web/API/Server-sent_events/Using_server-sent_events}{server-sent events}
from the stream. It currently only works with text mode connections so when calling
\code{req_perform_connection()} you must use \code{mode = "text"}.
}
}
