% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sur.R
\name{search.sur.stepwise}
\alias{search.sur.stepwise}
\title{Step-wise Search for Best SUR Models}
\usage{
search.sur.stepwise(
  y,
  x,
  xSizeSteps = list(c(1), c(2)),
  countSteps = c(NA, 10),
  savePre = NULL,
  ...
)
}
\arguments{
\item{y}{A matrix of endogenous data with variables in the columns.}

\item{x}{A matrix of exogenous data with variables in the columns.}

\item{xSizeSteps}{A list of model dimensions to be estimated in each step.
Its size determines the number of steps.}

\item{countSteps}{An integer vector to determine the number of variables to be used in each step.
\code{NA} means all variables. Variables are selected based on best estimations.
All variables in the best models (all metrics and targets) are selected until the corresponding suggested number is reached.
Select an appropriate value for \code{bestK} in the options.}

\item{savePre}{A directory for saving and loading the progress.
Each step's result is saved in a file (name=\code{paste0(savePre,i)} where \code{i} is the index of the step.}

\item{...}{other arguments to pass to \link{search.sur} function such as the \code{numTargets} argument.
Note that \code{xSizes} is ineffective here.}
}
\value{
Similar to \link{search.sur} function.
}
\description{
For a large model set, use this function to find the best seemingly unrelated regression models.
It selects a subset of variables from smaller models and moves to the bigger ones.
}
\examples{
# See the example in the 'search.sur' function.

}
\seealso{
\link{search.sur}, \link{estim.sur}
}
