% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{s.weight.from.metric}
\alias{s.weight.from.metric}
\title{Convert a Metric to Weight}
\usage{
s.weight.from.metric(value, metricName, minValue = 0)
}
\arguments{
\item{value}{Numeric value of the metric.}

\item{metricName}{Character string specifying the name of the metric.
See \link{get.search.metrics} function for the list of available options.}

\item{minValue}{A minimum value to be used for metrics with exponential weight formula.}
}
\value{
A numeric value representing the converted metric.
}
\description{
This function converts a metric to its weight equivalent.
}
\details{
Given a collection of models for the data, a metric is not
generally a metric of the relative quality of a model. This function
converts the value of a metric to such a number.
see \link{get.search.metrics} for more details.

The main purpose of exporting this statistics helper method is to show the inner calculations of the package.
}
\examples{
weight <- s.weight.from.metric(-3.4, "sic")
metric <- s.metric.from.weight(weight, "sic")

}
\seealso{
\link{s.metric.from.weight}
}
