% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/var_to_cholvar.R
\name{var_to_cholvar}
\alias{var_to_cholvar}
\title{Return R, Q and V0 with free and par for chol of matrix}
\usage{
var_to_cholvar(MLEobj)
}
\arguments{
\item{MLEobj}{A properly formatted MARSS model as output by \code{\link[=MARSS]{MARSS()}}}
}
\value{
A new \link[MARSS:marssMLE-class]{MARSS::marssMLE} object with new fixed, free, par and start
}
\description{
The free, fixed and par (and start) return the vec of the var-cov matrix M:
fixed + free\%*\%p = vec(M)
This function transforms the free, fixed, par and start so that they return the chol of the varcov matrix: vec(chol(M)).
}
\details{
Why does this function solve for the new par rather than just putting the
chol values in? Because the user might have scrambled the order of the
parameter list. I won't know which par correspond to which elements of the
var-cov matrix. The free matrix is what does the sorting/permutation of the
estimated parameters into their correct places. Also the matrix might be
block-diagonal, partially fixed, etc.

Restrictions
\itemize{
\item Q and R cannot be time-varying (at the moment)
}
}
\examples{
dat <- t(harborSealWA)[2:4, ]
fit <- MARSS(dat, model=list(Q="unconstrained"))
fitchol <- var_to_cholvar(fit)
Qchol = coef(fitchol, type="matrix")$Q
Q = coef(fit, type="matrix")$Q
Q
crossprod(Qchol)
Q = coef(fit, type="matrix", what="start")$Q
Qchol = coef(fitchol, type="matrix", what="start")$Q
Q
crossprod(Qchol)

fit <- MARSS(dat, model=list(Q=diag(0.1,3)+0.01), control=list(maxit=15))
fitchol <- var_to_cholvar(fit)
Qchol = coef(fitchol, type="matrix")$Q
Q = coef(fit, type="matrix")$Q
Q
crossprod(Qchol)
Q = coef(fit, type="matrix", what="start")$Q
Qchol = coef(fitchol, type="matrix", what="start")$Q
Q
crossprod(Qchol)
}
\author{
Eli Holmes.
}
