% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregates.R
\name{aggregation_map_helpers}
\alias{aggregation_map_helpers}
\alias{agg_table_to_agg_map}
\alias{agg_map_to_agg_table}
\title{Aggregation map conversions}
\usage{
agg_table_to_agg_map(.df, few_colname, many_colname)

agg_map_to_agg_table(aggregation_map, few_colname, many_colname)
}
\arguments{
\item{.df}{A data frame from which an aggregation map is to be extracted.}

\item{few_colname}{The string name of a column in a data frame that corresponds
to the "few" aggregated categories.}

\item{many_colname}{The string name of a column in a data frame that corresponds
to the "many" specific items that will be aggregated.}

\item{aggregation_map}{An aggregation map to be converted to a data frame.}
}
\value{
For \code{agg_table_to_agg_map()}, an aggregation map.
For \code{agg_map_to_agg_table()}, a \code{data.frame}, probably at \code{tibble}.
}
\description{
Aggregation is a many-to-few operation
where specifics are summed to comprise broader categories.
Examples include "John", "Paul", "George", and "Ringo"
aggregated to "Beatles"; and
"Mick", "Keith", "Ronnie", "Bill", and "Charlie"
aggregated to "Stones".
An aggregation map is a named list that describes the aggregation
to be performed.
An aggregation map for the examples above is
\code{list(Beatles = c("John", "Paul", "George", "Ringo"),  Stones = c("Mick", "Keith", "Ronnie", "Bill", "Charlie"))}
Aggregation maps can be generated from many shapes of data.
These functions assist with translating from different data shapes to
aggregation maps.
}
\examples{
bands <- tibble::tribble(~band, ~members, 
                         "The Beatles", "John", 
                         "The Beatles", "Paul", 
                         "The Beatles", "George", 
                         "The Beatles", "Ringo", 
                         # Rejects duplicates and NA
                         "The Beatles", "Ringo",
                         "The Beatles", NA, 
                         "Rolling Stones", "Mick", 
                         "Rolling Stones", "Keith",
                         "Rolling Stones", "Ronnie",
                         "Rolling Stones", "Bill",
                         "Rolling Stones", "Charlie")
agg_map <- agg_table_to_agg_map(bands, 
                                 few_colname = "band",
                                 many_colname = "members")
agg_map
agg_map_to_agg_table(agg_map, few_colname = "bands", many_colname = "members")
}
