% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Binary.R
\name{identical_byname}
\alias{identical_byname}
\title{Compare two matrices "by name" for exact equality}
\usage{
identical_byname(..., .summarise = FALSE)
}
\arguments{
\item{...}{Operands to be compared.}

\item{.summarise}{Tells whether the operation should be accomplished
across lists (\code{FALSE}) or down lists (\code{TRUE}).}
}
\value{
\code{TRUE} iff all information is identical, including
row and column types \emph{and}
row and column names \emph{and}
entries in the matrices.
}
\description{
If operands are matrices, they are completed and sorted relative to one another prior to comparison.
}
\details{
Comparisons are made by \code{identical(a, b)} so that variations among numbers
within the computational precision will return \code{FALSE}.

If fuzzy comparison is needed, use \code{\link{equal_byname}},
which compares using \code{isTRUE(all.equal(a, b))}.
}
\examples{
a <- matrix(1:4, nrow = 2)
b <- matrix(1:4, nrow = 2)
identical_byname(a, b)
identical_byname(a, b + 1e-100)
a <- a \%>\% setrowtype("Industries") \%>\% setcoltype("Commodities")
identical_byname(a, b) # FALSE because a has row and column types, but b does not.
b <- b \%>\% setrowtype("Industries") \%>\% setcoltype("Commodities")
identical_byname(a, b)
dimnames(a) <- list(c("i1", "i2"), c("c1", "c2"))
dimnames(b) <- list(c("c1", "c2"), c("i1", "i2"))
identical_byname(a, b) # FALSE, because row and column names are not equal
dimnames(b) <- dimnames(a)
identical_byname(a, b)
}
