% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MatrixUtils.R
\name{matrix-vector}
\alias{matrix-vector}
\alias{\%m*v\%}
\alias{crossprod_mv}
\title{Fast matrix-vector multiplications}
\usage{
M \%m*v\% v

crossprod_mv(M, v)
}
\arguments{
\item{M}{a matrix of class 'matrix', 'dgCMatrix', 'dsCMatrix', 'tabMatrix', or 'ddiMatrix'.}

\item{v}{a numeric vector.}
}
\value{
For \code{\%m*v\%} the vector \eqn{Mv} and for \code{crossprod_mv} the vector
 \eqn{M'v} where \eqn{M'} denotes the transpose of \eqn{M}.
}
\description{
Functions for matrix-vector multiplies like \code{\%*\%} and \code{crossprod},
but often faster for the matrix types supported. The return value is always a
numeric vector.
}
\examples{
M <- matrix(rnorm(10*10), 10, 10)
x <- rnorm(10)
M \%m*v\% x
crossprod_mv(M, x)
M <- Matrix::rsparsematrix(100, 100, nnz=100)
x <- rnorm(100)
M \%m*v\% x
crossprod_mv(M, x)

}
