% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cholesky.R
\name{chol_control}
\alias{chol_control}
\title{Set options for Cholesky decomposition}
\usage{
chol_control(perm = NULL, super = NA, ordering = 0L, inplace = TRUE)
}
\arguments{
\item{perm}{logical scalar, see \code{\link[Matrix]{Cholesky}}. If \code{NULL}, the default,
the choice is left to a simple heuristic.}

\item{super}{logical scalar, see \code{\link[Matrix]{Cholesky}}.}

\item{ordering}{an integer scalar passed to CHOLMOD routines determining which reordering
schemes are tried to limit sparse Cholesky fill-in.}

\item{inplace}{whether sparse Cholesky updates should re-use the same memory location.}
}
\value{
A list with specified options used for Cholesky decomposition.
}
\description{
These options are only effective in case the matrix to be decomposed is sparse, i.p.
of class \code{\link[Matrix]{dsCMatrix-class}}.
}
