% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cimDiablo.R
\name{cimDiablo}
\alias{cimDiablo}
\title{Clustered Image Maps (CIMs) ("heat maps") for DIABLO}
\usage{
cimDiablo(
  object,
  color = NULL,
  color.Y,
  color.blocks,
  comp = NULL,
  margins = c(2, 15),
  legend.position = "topright",
  transpose = FALSE,
  row.names = TRUE,
  col.names = TRUE,
  size.legend = 1.5,
  trim = TRUE,
  ...
)
}
\arguments{
\item{object}{An object of class inheriting from \code{"block.splsda"}.}

\item{color}{a character vector of colors such as that generated by
\code{\link{terrain.colors}}, \code{\link{topo.colors}},
\code{\link{rainbow}}, \code{\link{color.jet}} or similar functions.}

\item{color.Y}{a character vector of colors to be used for the levels of the
outcome}

\item{color.blocks}{a character vector of colors to be used for the blocks}

\item{comp}{positive integer. The similarity matrix is computed based on the
variables selected on those specified components. See example. Defaults to
\code{comp = 1}.}

\item{margins}{numeric vector of length two containing the margins (see
\code{\link{par}(mar)}) for column and row names respectively.}

\item{legend.position}{position of the legend, one of "bottomright",
"bottom", "bottomleft", "left", "topleft", "top", "topright", "right" and
"center".}

\item{transpose}{logical indicating if the matrix should be transposed for
plotting. Defaults to \code{FALSE}.}

\item{row.names, col.names}{logical, should the name of rows and/or columns
of \code{mat} be shown? If \code{TRUE} (defaults) \code{rownames(mat)}
and/or \code{colnames(mat)} are used. Possible character vectors with row
and/or column labels can be used.}

\item{size.legend}{size of the legend}

\item{trim}{(Logical or numeric) If FALSE, values are not changed. If TRUE,
the values are trimmed to 3 standard deviation range. If a numeric,
values with absolute values greater than the provided values are trimmed.}

\item{...}{Other valid arguments passed to \code{cim}.}
}
\value{
A list containing the following components: \item{M}{the mapped
matrix used by \code{cim}.} \item{rowInd, colInd}{row and column index
permutation vectors as returned by \code{\link{order.dendrogram}}.}
\item{ddr, ddc}{object of class \code{"dendrogram"} which describes the row
and column trees produced by \code{cim}.} \item{mat.cor}{the correlation
matrix used for the heatmap. Available only when mapping = "XY".}
\item{row.names, col.names}{character vectors with row and column labels
used.} \item{row.sideColors, col.sideColors}{character vector containing the
color names for vertical and horizontal side bars used to annotate the rows
and columns.}
}
\description{
This function generates color-coded Clustered Image Maps (CIMs) ("heat
maps") to represent "high-dimensional" data sets analysed with DIABLO.
}
\details{
This function is a small wrapper of \code{\link{cim}} specific to the DIABLO
framework.
}
\examples{
## default method: shows cross correlation between 2 data sets
#------------------------------------------------------------------
data(nutrimouse)
Y = nutrimouse$diet
data = list(gene = nutrimouse$gene, lipid = nutrimouse$lipid)

nutrimouse.sgccda <- block.splsda(X = data,
                                  Y = Y,
                                  design = "full",
                                  keepX = list(gene = c(10,10), lipid = c(15,15)),
                                  ncomp = 2,
                                  scheme = "centroid")

cimDiablo(nutrimouse.sgccda, comp = c(1,2))
## change trim range
cimDiablo(nutrimouse.sgccda, comp = c(1,2), trim = 4)
## do not trim values
cimDiablo(nutrimouse.sgccda, comp = c(1,2), trim = FALSE)
}
\references{
Singh A., Shannon C., Gautier B., Rohart F., Vacher M., Tebbutt S.
and Lê Cao K.A. (2019), DIABLO: an integrative approach for identifying key 
molecular drivers from multi-omics assays, Bioinformatics, 
Volume 35, Issue 17, 1 September 2019, Pages 3055–3062.

Eisen, M. B., Spellman, P. T., Brown, P. O. and Botstein, D. (1998). Cluster
analysis and display of genome-wide expression patterns. \emph{Proceeding of
the National Academy of Sciences of the USA} \bold{95}, 14863-14868.

Weinstein, J. N., Myers, T. G., O'Connor, P. M., Friend, S. H., Fornace Jr.,
A. J., Kohn, K. W., Fojo, T., Bates, S. E., Rubinstein, L. V., Anderson, N.
L., Buolamwini, J. K., van Osdol, W. W., Monks, A. P., Scudiero, D. A.,
Sausville, E. A., Zaharevitz, D. W., Bunow, B., Viswanadhan, V. N., Johnson,
G. S., Wittes, R. E. and Paull, K. D. (1997). An information-intensive
approach to the molecular pharmacology of cancer. \emph{Science} \bold{275},
343-349.

González I., Lê Cao K.A., Davis M.J., Déjean S. (2012). Visualising
associations between paired 'omics' data sets. \emph{BioData Mining};
\bold{5}(1).

mixOmics article:

Rohart F, Gautier B, Singh A, Lê Cao K-A. mixOmics: an R package for 'omics
feature selection and multiple data integration. PLoS Comput Biol 13(11):
e1005752
}
\seealso{
\code{\link{cim}}, \code{\link{heatmap}}, \code{\link{hclust}},
\code{\link{plotVar}}, \code{\link{network}} and

\url{http://mixomics.org/mixDIABLO/} for more details on all options
available.
}
\author{
Amrit Singh, Florian Rohart, Kim-Anh Lê Cao, Al J Abadi
}
\keyword{cluster}
\keyword{graphs}
\keyword{hplot}
\keyword{iplot}
\keyword{multivariate}
