% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMarkers.R
\name{plotMarkers}
\alias{plotMarkers}
\title{Plot the values for multivariate markers in block analyses}
\usage{
plotMarkers(
  object,
  block,
  markers = NULL,
  comp = 1,
  group = NULL,
  col.per.group = NULL,
  global = FALSE,
  title = NULL,
  violin = TRUE,
  boxplot.width = NULL,
  violin.width = 0.9
)
}
\arguments{
\item{object}{An object of class \code{block.splsda} or \code{block.spls}}

\item{block}{Name or index of the block to use}

\item{markers}{Character or integer, only include these markers. If integer,
the top 'markers' features are shown}

\item{comp}{Integer, the component to use}

\item{group}{Factor, the grouping variable (only required for
\code{block.spls} objects)}

\item{col.per.group}{character (or symbol) color to be used when 'group' is
defined. Vector of the same length as the number of groups.}

\item{global}{Logical indicating whether to show the global plots (TRUE) or
segregate by feature (FALSE). Only available when \code{object$scale=TRUE}}

\item{title}{The plot title}

\item{violin}{(if global = FALSE) Logical indicating whether violin plots should also be shown}

\item{boxplot.width}{Numeric, adjusts the width of the box plots}

\item{violin.width}{Numeric, adjusts the width of the violin plots}
}
\value{
A ggplot object
}
\description{
Plots the standardised values (after centring and/or scaling) for the
selected variables for a given block on a given component. Only applies to
\code{block.splsda} or \code{block.spls}.
}
\examples{
# see ?block.splsda and ?block.spls
}
\seealso{
\code{\link{plotLoadings}}, \code{\link{block.splsda}}, \code{\link{block.spls}}
}
