% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contour_plot.R
\name{contour_plot}
\alias{contour_plot}
\title{Contour plots of functions of two variables}
\usage{
contour_plot(
  ...,
  npts = 100,
  labels = TRUE,
  filled = TRUE,
  contours_at = NULL,
  n_contours = 10,
  n_fill = 50,
  alpha = 1,
  fill_alpha = 0.1,
  label_alpha = 1,
  label_placement = 0.5,
  contour_color = "blue",
  label_color = contour_color,
  skip = 1,
  guide = FALSE,
  guide_title = "output",
  color_scale = scale_color_viridis_c(),
  fill_scale = scale_fill_viridis_d()
)
}
\arguments{
\item{\dots}{Canonical first "three" arguments: \verb{[Previous layer]}, tilde expression, \link{domain}}

\item{npts}{Integer number of points on each axis at which to evaluate the function}

\item{labels}{Logical flag: label the contours}

\item{filled}{Logical flag: fill between the contours}

\item{contours_at}{Vector of numbers. Contours will be drawn
at these levels of the output.}

\item{n_contours}{hint at number of contours to show}

\item{n_fill}{Integer number of points for calculating fill}

\item{alpha}{Transparency of contours in \verb{[0-1]}}

\item{fill_alpha}{Transparency of fill}

\item{label_alpha}{Likewise, for contour labels}

\item{label_placement}{A number, between 0 and 1, suggesting where to place
the contour labels. Default: 0.5. This can be useful when there are two contour layers in one plaot.}

\item{contour_color}{Set to a string, e.g. \code{"blue"} for contours
to be drawn in a fixed color}

\item{label_color}{Defaults to \code{contour_color}. Can be set to a}

\item{skip}{Small integer. Skip this many contours between labeled contours}

\item{guide}{Logical flag, whether to show a color guide.}

\item{guide_title}{Character string  for title of guide (if any)}

\item{color_scale}{See ggplot2 color scales.}

\item{fill_scale}{See ggplot2 fill scales}
}
\value{
ggplot2 graphics layers
}
\description{
Creates a ggplot2-compatible contour plot of a function
of two variables.
}
\examples{
\dontrun{
contour_plot(sin(0.2*x*y) ~ x & y, domain(x=-10.3:4.5, y=2:7.5))
contour_plot(x + y ~ x & y)
contour_plot(sin(0.2*x*y)) # but better to use tilde expression
}

}
