% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Basis_sets.R
\name{basis_sets}
\alias{basis_sets}
\alias{legendre_set}
\alias{legendre_M}
\alias{ns_set}
\alias{fourier_M}
\alias{ns_M}
\alias{fourier_set}
\title{Basis sets for for function approximation}
\usage{
legendre_set(df = 3, left = -1, right = 1)

legendre_M(x, df, left = -1, right = 1)

ns_set(df = 3, left = -1, right = 1)

fourier_M(x, n, fperiod = NULL)

ns_M(x, df = NULL, knots = NULL, intercept = FALSE, Boundary.knots = range(x))

fourier_set(df, left = -1, right = 1)
}
\arguments{
\item{df}{number of basis functions to construct}

\item{left}{number giving left-hand boundary of the interval}

\item{right}{number giving right-hand boundary of the interval}

\item{x}{inputs at which to evaluate the functions (in the \verb{_M} functions)}

\item{n}{number of fourier components to generate}

\item{fperiod}{number giving the fundamental period length for the Fourier basis}

\item{knots}{breakpoints that define the spline.  The default is no
    knots; together with the natural boundary conditions this results in
    a basis for linear regression on \code{x}.  Typical values are the
    mean or median for one knot, quantiles for more knots.  See also
    \code{Boundary.knots}.}

\item{intercept}{if \code{TRUE}, an intercept is included in the
    basis; default is \code{FALSE}.}

\item{Boundary.knots}{boundary points at which to impose the natural
    boundary conditions and anchor the B-spline basis (default the range
    of the data).  If both \code{knots} and \code{Boundary.knots} are
    supplied, the basis parameters do not depend on \code{x}. Data can
    extend beyond \code{Boundary.knots}}
}
\value{
The \verb{_M} functions return a model matrix. The \verb{_set} functions
return a function with arguments \code{x} and \code{n}. The integer \code{n} specifies
which function to use, while \code{x} is the set of values at which to evaluate
that function.
}
\description{
These functions generate the mathematical functions for three
different basis sets: Fourier (sines), Legendre (orthogonal polynomials),
and Splines (low-order smooth approximation)
}
\details{
For each basis, there are two different forms for the
generating functions. Names ending in \verb{_set} create a set of functions with
arguments \code{x} and \code{n}, where integer \code{n} provides an index into the set.
The same names with a \verb{_M} suffix produce a model matrix
corresponding to a specified set of x values. These are useful
with \code{lm()} and similar model-building functions in the same way that
\code{poly()} and \code{ns()} are useful. (\code{ns_M()} is just an alias for \code{splines::ns()}.) Like
\code{poly()} and \code{ns()}, the \verb{_M} suffix functions do \emph{NOT} include an
intercept column.
}
