% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symbolicD.R
\name{symbolicD}
\alias{symbolicD}
\title{Symbolic Derivatives}
\usage{
symbolicD(tilde, ..., .order)
}
\arguments{
\item{tilde}{a tilde expression with the function call on the left side and the w.r.t. variables
on the right side.}

\item{\dots}{additional parameters, typically default values for mathematical parameters}

\item{.order}{a number specifying the order of a derivative with respect to a single variable}
}
\value{
a function implementing the derivative
}
\description{
Constructs symbolic derivatives of some mathematical expressions
}
\details{
Uses the Derivs package for constructing the derivative
The \code{.order} argument is just for convenience when programming
high-order derivatives, e.g. the 5th derivative w.r.t. one variable.

When re-assigning default values for arguments in a function
being called, as in \code{D(dnorm(x, mean=3) ~ x)}, you will get a
numerical derivative even when the analytic form is known. To avoid
this (when possible) use \code{D(dnorm(x) ~ x, mean=3)}
}
\examples{
symbolicD( a*x^2 ~ x)
symbolicD( a*x^2 ~ x&x)
symbolicD( a*sin(x)~x, .order=4)
symbolicD( a*x^2*y+b*y ~ x, a=10, b=100 )
symbolicD( dnorm(x, mn, sd) ~ x, mn=3, sd=2)
}
\seealso{
\code{\link{D}}, \code{\link{numD}},  \code{\link{antiD}}, \code{\link{plotFun}}
}
\author{
Daniel Kaplan (\email{kaplan@macalester.edu})
}
