% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_remove_row_heights}
\alias{wb_remove_row_heights}
\title{Remove custom row heights from a worksheet}
\usage{
wb_remove_row_heights(wb, sheet = current_sheet(), rows)
}
\arguments{
\item{wb}{A workbook object}

\item{sheet}{A name or index of a worksheet}

\item{rows}{Indices of rows to remove custom height (if any) from.}
}
\description{
Remove row heights from a worksheet
}
\examples{
## Create a new workbook
wb <- wb_load(file = system.file("extdata", "openxlsx2_example.xlsx", package = "openxlsx2"))

## remove any custom row heights in rows 1 to 10
wb$remove_row_heights(1, rows = 1:10)
}
\seealso{
\code{\link[=wb_set_row_heights]{wb_set_row_heights()}}
}
