% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates.R
\name{convert_date}
\alias{convert_date}
\alias{convert_datetime}
\alias{convert_hms}
\title{Convert from excel date, datetime or hms number to R Date type}
\usage{
convert_date(x, origin = "1900-01-01", ...)

convert_datetime(x, origin = "1900-01-01", ...)

convert_hms(x)
}
\arguments{
\item{x}{A vector of integers}

\item{origin}{date. Default value is for Windows Excel 2010}

\item{...}{additional parameters passed to as.Date()}
}
\description{
Convert from excel date number to R Date type
}
\details{
Excel stores dates as number of days from some origin day
}
\examples{
## 2014 April 21st to 25th
convert_date(c(41750, 41751, 41752, 41753, 41754, NA))
convert_date(c(41750.2, 41751.99, NA, 41753))
## 2014-07-01, 2014-06-30, 2014-06-29
x <- c(41821.8127314815, 41820.8127314815, NA, 41819, NaN)
convert_datetime(x)
convert_datetime(x, tz = "Australia/Perth")
convert_datetime(x, tz = "UTC")
## 12:13:14
x <- 0.50918982
convert_hms(x)
}
\seealso{
\code{\link[=write_data]{write_data()}}
}
