% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-worksheet.R
\name{wbWorksheet}
\alias{wbWorksheet}
\title{R6 class for a Workbook Worksheet}
\value{
The \code{wbWorksheet} object

The \code{wbWorksheet} object
}
\description{
R6 class for a Workbook Worksheet

R6 class for a Workbook Worksheet
}
\details{
A Worksheet
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{sheetPr}}{sheetPr}

\item{\code{dimension}}{dimension}

\item{\code{sheetViews}}{sheetViews}

\item{\code{sheetFormatPr}}{sheetFormatPr}

\item{\code{sheet_data}}{sheet_data}

\item{\code{cols_attr}}{cols_attr}

\item{\code{autoFilter}}{autoFilter}

\item{\code{mergeCells}}{mergeCells}

\item{\code{conditionalFormatting}}{conditionalFormatting}

\item{\code{dataValidations}}{dataValidations}

\item{\code{freezePane}}{freezePane}

\item{\code{hyperlinks}}{hyperlinks}

\item{\code{sheetProtection}}{sheetProtection}

\item{\code{pageMargins}}{pageMargins}

\item{\code{pageSetup}}{pageSetup}

\item{\code{headerFooter}}{headerFooter}

\item{\code{rowBreaks}}{rowBreaks}

\item{\code{colBreaks}}{colBreaks}

\item{\code{drawing}}{drawing}

\item{\code{legacyDrawing}}{legacyDrawing}

\item{\code{legacyDrawingHF}}{legacyDrawingHF}

\item{\code{oleObjects}}{oleObjects}

\item{\code{tableParts}}{tableParts}

\item{\code{extLst}}{extLst}

\item{\code{cellWatches}}{cellWatches}

\item{\code{controls}}{controls}

\item{\code{customProperties}}{customProperties}

\item{\code{customSheetViews}}{customSheetViews}

\item{\code{dataConsolidate}}{dataConsolidate}

\item{\code{drawingHF}}{drawingHF}

\item{\code{relships}}{relships}

\item{\code{ignoredErrors}}{ignoredErrors}

\item{\code{phoneticPr}}{phoneticPr}

\item{\code{picture}}{picture}

\item{\code{printOptions}}{printOptions}

\item{\code{protectedRanges}}{protectedRanges}

\item{\code{scenarios}}{scenarios}

\item{\code{sheetCalcPr}}{sheetCalcPr}

\item{\code{smartTags}}{smartTags}

\item{\code{sortState}}{sortState}

\item{\code{webPublishItems}}{webPublishItems}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-wbWorksheet-new}{\code{wbWorksheet$new()}}
\item \href{#method-wbWorksheet-get_prior_sheet_data}{\code{wbWorksheet$get_prior_sheet_data()}}
\item \href{#method-wbWorksheet-get_post_sheet_data}{\code{wbWorksheet$get_post_sheet_data()}}
\item \href{#method-wbWorksheet-unfold_cols}{\code{wbWorksheet$unfold_cols()}}
\item \href{#method-wbWorksheet-fold_cols}{\code{wbWorksheet$fold_cols()}}
\item \href{#method-wbWorksheet-merge_cells}{\code{wbWorksheet$merge_cells()}}
\item \href{#method-wbWorksheet-unmerge_cells}{\code{wbWorksheet$unmerge_cells()}}
\item \href{#method-wbWorksheet-clean_sheet}{\code{wbWorksheet$clean_sheet()}}
\item \href{#method-wbWorksheet-add_page_break}{\code{wbWorksheet$add_page_break()}}
\item \href{#method-wbWorksheet-set_print_options}{\code{wbWorksheet$set_print_options()}}
\item \href{#method-wbWorksheet-append}{\code{wbWorksheet$append()}}
\item \href{#method-wbWorksheet-add_sparklines}{\code{wbWorksheet$add_sparklines()}}
\item \href{#method-wbWorksheet-set_sheetview}{\code{wbWorksheet$set_sheetview()}}
\item \href{#method-wbWorksheet-ignore_error}{\code{wbWorksheet$ignore_error()}}
\item \href{#method-wbWorksheet-clone}{\code{wbWorksheet$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-new"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-new}{}}}
\subsection{Method \code{new()}}{
Creates a new \code{wbWorksheet} object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$new(
  tabColor = NULL,
  oddHeader = NULL,
  oddFooter = NULL,
  evenHeader = NULL,
  evenFooter = NULL,
  firstHeader = NULL,
  firstFooter = NULL,
  paperSize = 9,
  orientation = "portrait",
  hdpi = 300,
  vdpi = 300,
  printGridLines = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tabColor}}{tabColor}

\item{\code{oddHeader}}{oddHeader}

\item{\code{oddFooter}}{oddFooter}

\item{\code{evenHeader}}{evenHeader}

\item{\code{evenFooter}}{evenFooter}

\item{\code{firstHeader}}{firstHeader}

\item{\code{firstFooter}}{firstFooter}

\item{\code{paperSize}}{paperSize}

\item{\code{orientation}}{orientation}

\item{\code{hdpi}}{hdpi}

\item{\code{vdpi}}{vdpi}

\item{\code{printGridLines}}{printGridLines}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a \code{wbWorksheet} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-get_prior_sheet_data"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-get_prior_sheet_data}{}}}
\subsection{Method \code{get_prior_sheet_data()}}{
Get prior sheet data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$get_prior_sheet_data()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector of xml
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-get_post_sheet_data"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-get_post_sheet_data}{}}}
\subsection{Method \code{get_post_sheet_data()}}{
Get post sheet data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$get_post_sheet_data()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A character vector of xml
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-unfold_cols"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-unfold_cols}{}}}
\subsection{Method \code{unfold_cols()}}{
unfold \verb{<cols ..>} node to dataframe. \verb{<cols><col ..>} are compressed.
Only columns with attributes are written to the file. This function
unfolds them so that each cell beginning with the "A" to the last one
found in cc gets a value.
TODO might extend this to match either largest cc or largest col. Could
be that "Z" is formatted, but the last value is written to "Y".
TODO might replace the xml nodes with the data frame?
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$unfold_cols()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The column data frame
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-fold_cols"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-fold_cols}{}}}
\subsection{Method \code{fold_cols()}}{
fold the column dataframe back into a node.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$fold_cols(col_df)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{col_df}}{the column data frame}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorksheetObject}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-merge_cells"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-merge_cells}{}}}
\subsection{Method \code{merge_cells()}}{
Set cell merging for a sheet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$merge_cells(rows = NULL, cols = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows, cols}}{Row and column specifications.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-unmerge_cells"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-unmerge_cells}{}}}
\subsection{Method \code{unmerge_cells()}}{
Removes cell merging for a sheet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$unmerge_cells(rows = NULL, cols = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows, cols}}{Row and column specifications.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorkbook} object, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-clean_sheet"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-clean_sheet}{}}}
\subsection{Method \code{clean_sheet()}}{
clean sheet (remove all values)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$clean_sheet(
  dims = NULL,
  numbers = TRUE,
  characters = TRUE,
  styles = TRUE,
  merged_cells = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dims}}{dimensions}

\item{\code{numbers}}{remove all numbers}

\item{\code{characters}}{remove all characters}

\item{\code{styles}}{remove all styles}

\item{\code{merged_cells}}{remove all merged_cells}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorksheetObject}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-add_page_break"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-add_page_break}{}}}
\subsection{Method \code{add_page_break()}}{
add page break
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$add_page_break(row = NULL, col = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{row}}{row}

\item{\code{col}}{col}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-set_print_options"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-set_print_options}{}}}
\subsection{Method \code{set_print_options()}}{
add print options
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$set_print_options(
  gridLines = NULL,
  gridLinesSet = NULL,
  headings = NULL,
  horizontalCentered = NULL,
  verticalCentered = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{gridLines}}{gridLines}

\item{\code{gridLinesSet}}{gridLinesSet}

\item{\code{headings}}{If TRUE prints row and column headings}

\item{\code{horizontalCentered}}{If TRUE the page is horizontally centered}

\item{\code{verticalCentered}}{If TRUE the page is vertically centered}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-append"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-append}{}}}
\subsection{Method \code{append()}}{
append a field.  Intended for internal use only.  Not
guaranteed to remain a public method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$append(field, value = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{a field name}

\item{\code{value}}{a new value}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorksheetObject}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-add_sparklines"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-add_sparklines}{}}}
\subsection{Method \code{add_sparklines()}}{
add sparkline
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$add_sparklines(sparklines)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sparklines}}{sparkline created by \code{create_sparkline()}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorksheetObject}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-set_sheetview"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-set_sheetview}{}}}
\subsection{Method \code{set_sheetview()}}{
add sheetview
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$set_sheetview(
  colorId = NULL,
  defaultGridColor = NULL,
  rightToLeft = NULL,
  showFormulas = NULL,
  showGridLines = NULL,
  showOutlineSymbols = NULL,
  showRowColHeaders = NULL,
  showRuler = NULL,
  showWhiteSpace = NULL,
  showZeros = NULL,
  tabSelected = NULL,
  topLeftCell = NULL,
  view = NULL,
  windowProtection = NULL,
  workbookViewId = NULL,
  zoomScale = NULL,
  zoomScaleNormal = NULL,
  zoomScalePageLayoutView = NULL,
  zoomScaleSheetLayoutView = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{colorId}}{colorId}

\item{\code{defaultGridColor}}{defaultGridColor}

\item{\code{rightToLeft}}{rightToLeft}

\item{\code{showFormulas}}{showFormulas}

\item{\code{showGridLines}}{showGridLines}

\item{\code{showOutlineSymbols}}{showOutlineSymbols}

\item{\code{showRowColHeaders}}{showRowColHeaders}

\item{\code{showRuler}}{showRuler}

\item{\code{showWhiteSpace}}{showWhiteSpace}

\item{\code{showZeros}}{showZeros}

\item{\code{tabSelected}}{tabSelected}

\item{\code{topLeftCell}}{topLeftCell}

\item{\code{view}}{view}

\item{\code{windowProtection}}{windowProtection}

\item{\code{workbookViewId}}{workbookViewId}

\item{\code{zoomScale}}{zoomScale}

\item{\code{zoomScaleNormal}}{zoomScaleNormal}

\item{\code{zoomScalePageLayoutView}}{zoomScalePageLayoutView}

\item{\code{zoomScaleSheetLayoutView}}{zoomScaleSheetLayoutView}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorksheetObject}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-ignore_error"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-ignore_error}{}}}
\subsection{Method \code{ignore_error()}}{
Ignore error on worksheet
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$ignore_error(
  dims = "A1",
  calculatedColumn = FALSE,
  emptyCellReference = FALSE,
  evalError = FALSE,
  formula = FALSE,
  formulaRange = FALSE,
  listDataValidation = FALSE,
  numberStoredAsText = FALSE,
  twoDigitTextYear = FALSE,
  unlockedFormula = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{dims}}{dims}

\item{\code{calculatedColumn}}{calculatedColumn}

\item{\code{emptyCellReference}}{emptyCellReference}

\item{\code{evalError}}{evalError}

\item{\code{formula}}{formula}

\item{\code{formulaRange}}{formulaRange}

\item{\code{listDataValidation}}{listDataValidation}

\item{\code{numberStoredAsText}}{numberStoredAsText}

\item{\code{twoDigitTextYear}}{twoDigitTextYear}

\item{\code{unlockedFormula}}{unlockedFormula}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The \code{wbWorksheetObject}, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-wbWorksheet-clone"></a>}}
\if{latex}{\out{\hypertarget{method-wbWorksheet-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{wbWorksheet$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
