% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_cell_style}
\alias{wb_cell_style}
\alias{wb_get_cell_style}
\alias{wb_set_cell_style}
\title{Apply styling to a cell region}
\usage{
wb_get_cell_style(wb, sheet = current_sheet(), dims)

wb_set_cell_style(wb, sheet = current_sheet(), dims, style)
}
\arguments{
\item{wb}{A \code{wbWorkbook} object}

\item{sheet}{sheet}

\item{dims}{A cell range in the worksheet}

\item{style}{A style}
}
\value{
wb_get_cell_style returns the style id as character

wb_set_cell_style returns the workbook invisibly.
}
\description{
Apply styling to a cell region
}
\examples{
# set a style in b1
wb <- wb_workbook()$add_worksheet()$
  add_numfmt(dims = "B1", numfmt = "#,0")

# get style from b1 to assign it to a1
numfmt <- wb$get_cell_style(dims = "B1")

# assign style to a1
wb$set_cell_style(dims = "A1", style = numfmt)
}
\seealso{
Other styles: 
\code{\link{wb_add_border}()},
\code{\link{wb_add_cell_style}()},
\code{\link{wb_add_fill}()},
\code{\link{wb_add_font}()},
\code{\link{wb_add_named_style}()},
\code{\link{wb_add_numfmt}()}
}
\concept{styles}
