% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareCurv.R
\name{compareCurv}
\alias{compareCurv}
\title{Centile curves according to different methods}
\usage{
compareCurv(x, y, bandwidth.method = "CV", lambdas, data, leg = FALSE)
}
\arguments{
\item{x}{the explanatory variable - numeric}

\item{y}{the response variable - numeric}

\item{bandwidth.method}{the method chosen to calculate bandwdth. Could be cross validation or Plug-in. Default is set to CV.}

\item{lambdas}{to be set for "B-Splines". Can be a vector or a single numeric value. Tunes the tradeoff between the goodness of fit and the regularity of the spline - numeric value or numeric vector}

\item{data}{the abnormal/external data we want to compare the curves with}

\item{leg}{Boolean. Should the legend be desplayed (TRUE) or not (FALSE).}
}
\value{
Plots centile curves with the different methods and displays them on the same figure as the noise data to compare
}
\description{
Centile curves according to different methods
}
\examples{
#create a sample data frame
sample<-data.frame(sample(30:42,30,rep=TRUE),sample(800:5000,30,rep=TRUE))
colnames(sample)<-c("Gestational Age in weeks","Weight in gramms")
x<-sample$`Gestational Age in weeks`
y<-sample$`Weight in gramms`
abnormal<-data.frame(sample(30:42,6,rep=TRUE),sample(800:5000,6,rep=TRUE))
colnames(abnormal)<-c("Gestational Age in weeks","Weight in gramms")
compareCurv(x,y,bandwidth.method="Plug-in",lambdas=1,abnormal)
}
