% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_merge_pairs.R, R/merge_pairs.R
\name{merge_pairs.cluster_pairs}
\alias{merge_pairs.cluster_pairs}
\alias{rbind.cluster_pairs}
\alias{merge_pairs}
\alias{merge_pairs.pairs}
\alias{rbind.pairs}
\title{Merge two sets of pairs into one}
\usage{
\method{merge_pairs}{cluster_pairs}(
  pairs1,
  pairs2,
  name = paste(pairs1$name, pairs2$name, sep = "+"),
  ...
)

\method{rbind}{cluster_pairs}(...)

merge_pairs(pairs1, pairs2, ...)

\method{merge_pairs}{pairs}(pairs1, pairs2, ...)

\method{rbind}{pairs}(...)
}
\arguments{
\item{pairs1}{the first set of pairs}

\item{pairs2}{the second set of pairs}

\item{name}{name of new object to assign the pairs to on the cluster
nodes.}

\item{...}{for \code{rbind} the \code{pairs} or \code{cluster_pairs} objects 
the need to be combined; for \code{merge_pairs} these are passed on to 
other methods.}
}
\value{
Returns a \code{pairs} or \code{cluster_pairs} object where both sets of pairs
are combined. Duplicate pairs are removed. 

In case of \code{merge_pairs.cluster_pairs}, \code{merge_pairs.pairs} is called on
each cluster node and the resulting pairs are assigned to \code{name} in
the environment \code{reclin_env}.
}
\description{
Merge two sets of pairs into one
}
\details{
The function will give an error when the two sets of pairs have different values
for \code{attr(pairs1, "x")} and \code{attr(pairs1, "y")}. When there attributes
are missing the code will execute; the user is then responsible for ensuring that
the indices in \code{pairs1} and \code{pairs2} refer to the same datasets.
}
