% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rfinterval.R
\name{rfinterval}
\alias{rfinterval}
\title{Prediction Intervals for Random forests}
\usage{
rfinterval(formula = NULL, train_data = NULL, test_data = NULL,
  method = c("oob", "split-conformal", "quantreg"), alpha = 0.1,
  symmetry = TRUE, seed = NULL, params_ranger = NULL)
}
\arguments{
\item{formula}{Object of class \code{formula} or character describing the model to fit. Interaction terms supported only for numerical variables.}

\item{train_data}{Training data of class data.frame, matrix, or dgCMatrix (Matrix).}

\item{test_data}{Test data of class data.frame, matrix, or dgCMatrix (Matrix).}

\item{method}{Method for constructing prediction interval. If method = "oob", compute the out-of-bag prediction intervals; if method = "split-conformal", compute the split conformal prediction interval; if method = "quantreg", use quantile regression forest to compute prediction intervals.}

\item{alpha}{Confidence level. alpha = 0.05 for the 95\% prediction interval.}

\item{symmetry}{True if constructing symmetric out-of-bag prediction intervals, False otherwise. Only for method = "oob"}

\item{seed}{Seed (only for method = "split-conformal")}

\item{params_ranger}{List of further parameters that should be passed to ranger. See \code{\link[ranger]{ranger}} for possible parameters.}
}
\value{
\item{\code{oob_interval}}{Out-of-bag prediction intervals}
\item{\code{sc_interval}}{Split-conformal prediction intervals}
\item{\code{quantreg_interval}}{Quantile regression forest prediction intervals}
\item{\code{alpha}}{Confidence level for prediction intervals}
\item{\code{testPred}}{Random forest prediction for test set}
\item{\code{train_data}}{Training data}
\item{\code{test_data}}{Test data}
}
\description{
The \code{rfinterval} constructs prediction intervals for random forest predictions using a fast implementation package 'ranger'.
}
\examples{
\donttest{
train_data <- sim_data(n = 500, p = 8)
test_data <- sim_data(n = 500, p = 8)
output <- rfinterval(y~., train_data = train_data, test_data = test_data,
                     method = c("oob", "split-conformal", "quantreg"),
                     symmetry = TRUE,alpha = 0.1)
y <- test_data$y
mean(output$oob_interval$lo < y & output$oob_interval$up > y)
mean(output$sc_interval$lo < y & output$sc_interval$up > y)
mean(output$quantreg_interval$lo < y & output$quantreg_interval$up > y)
}
}
\references{
Haozhe Zhang, Joshua Zimmerman, Dan Nettleton, and Dan Nordman. (2019). "Random Forest Prediction Intervals." The American Statistician. Doi: 10.1080/00031305.2019.1585288.

Haozhe Zhang. (2019). "Topics in Functional Data Analysis and Machine Learning Predictive Inference." Ph.D. Dissertations. Iowa State University Digital Repository. 17929.

Lei, J., Max G’Sell, Alessandro Rinaldo, Ryan J. Tibshirani, and Larry Wasserman. "Distribution-free predictive inference for regression." Journal of the American Statistical Association 113, no. 523 (2018): 1094-1111.

Meinshausen, Nicolai. "Quantile regression forests." Journal of Machine Learning Research 7 (2006): 983-999.

Leo Breiman. (2001). Random Forests. Machine Learning 45(1), 5-32.
}
