% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stanMisc.r
\name{print.rmsb}
\alias{print.rmsb}
\title{Basic Print for Bayesian Parameter Summary}
\usage{
\method{print}{rmsb}(x, prob = 0.95, dec = 4, intercepts = TRUE, pr = TRUE, ...)
}
\arguments{
\item{x}{an object created by an \code{rms} Bayesian fitting function}

\item{prob}{HPD interval coverage probability (default is 0.95)}

\item{dec}{amount of rounding (digits to the right of the decimal)}

\item{intercepts}{set to \code{FALSE} to not print intercepts}

\item{pr}{set to \code{FALSE} to return an unrounded matrix and not print}

\item{...}{ignored}
}
\value{
matrix (rounded if \code{pr=TRUE})
}
\description{
For a Bayesian regression fit prints the posterior mean, median, SE, highest posterior density interval, and symmetry coefficient from the posterior draws.  For a given parameter, the symmetry measure is computed using the \code{distSym} function.
}
\examples{
\dontrun{
  f <- blrm(...)
  print.rmsb(f)
}
}
\author{
Frank Harrell
}
