% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_models_fm.R
\name{plot_models_fm}
\alias{plot_models_fm}
\title{Plot Models on a Chi-Squares-vs-Dfs Graph}
\usage{
plot_models_fm(
  ...,
  fit_measure = c("cfi", "tli", "rmsea"),
  fit_values,
  line_size = 1,
  label_size = 8,
  point_size = 5,
  position_dodge = 0.5,
  include_model_values = FALSE,
  include_baseline = FALSE
)
}
\arguments{
\item{...}{The \link[lavaan:lavaan-class]{lavaan::lavaan}
objects to be plotted. Can also be a
named list of the
\link[lavaan:lavaan-class]{lavaan::lavaan} objects. If it
is as list, it must be named and the
names will be used in the plot.}

\item{fit_measure}{A length-one
character vector of the fit measures
to use to plot the lines. Only
supports \code{"cfi"} (the default),
\code{"tli"}, and \code{"rmsea"}.}

\item{fit_values}{A numeric vector
of the values of the fit measure
used to plot the lines. The default
values are \code{c(.90, .95)} for \code{"cfi"}
and \code{"tli"}, and
\code{c(.00, .02, .05, .08)} for
\code{"rmsea"}.}

\item{line_size}{The size of the
lines. Default is 1.}

\item{label_size}{The size of the
model names. Default is 8.}

\item{point_size}{The size of the
point representing a model. Default
is 2.}

\item{position_dodge}{Offsetting the
label of a model from the point.
Default is .5. Used by
\code{\link[ggrepel:geom_text_repel]{ggrepel::geom_label_repel()}}.}

\item{include_model_values}{If \code{TRUE}
, the values of the models on
\code{fit_measure} will be added to
\code{fit_values}. Default is \code{FALSE.}}

\item{include_baseline}{If \code{TRUE},
the baseline model is included in the
plot. Default is \code{FALSE}.}
}
\value{
Return a \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}}
output that can be further modified.
}
\description{
Plot models on a graph
with model chi-square against model
the degrees of freedom, with lines
for equal fit measures.
}
\details{
This function plots models
based on their model chi-squares and
model degrees of freedoms.It can
also add lines for chi-square-df
combination with equal values on
selected fit measures. Currently
supports CFI, TLI, and RMSEA.
}
\examples{


library(lavaan)

# From the help page of modificationIndices

HS.model <- '
 visual  =~ x1 + x2 + x3
 textual =~ x4 + x5 + x6
 speed   =~ x7 + x8 + x9
'

fit <- cfa(HS.model, data = HolzingerSwineford1939)
modindices(fit, sort = TRUE, op = "=~")

fit2 <- update(fit, add = "visual =~ x9")
fit3 <- update(fit, add = "textual =~ x3\nvisual =~ x7")

models <- list(Initial = fit,
               Model_2 = fit2,
               Model_3 = fit3)
fit_cfi <- sapply(models, fitMeasures, fit.measures = "cfi")
fit_tli <- sapply(models, fitMeasures, fit.measures = "tli")
fit_rmsea <- sapply(models, fitMeasures, fit.measures = "rmsea")

# Supply the models as arguments
plot_models_fm(fit, fit2, fit3)

# Plot lines for selected values on a fit measure (CFI by default)
plot_models_fm(fit, fit2, fit3, fit_values = c(.90, .925, .95, fit_cfi))

# Plot the models' values on the fit measures
plot_models_fm(fit, fit2, fit3, include_model_values = TRUE)

# Supply the models as a named list
plot_models_fm(list(A = fit, B = fit2, C = fit3),
               fit_values = c(.90, .925, .95))

# Plot the models, fit measure set to TLI
plot_models_fm(fit, fit2, fit3, fit_measure = "tli")
plot_models_fm(fit, fit2, fit3, fit_measure = "tli",
               fit_values = c(.90, .925, .95, fit_tli))
plot_models_fm(fit, fit2, fit3, fit_measure = "tli",
               include_model_values = TRUE)

# Plot the models, fit measure set to RMSEA
plot_models_fm(fit, fit2, fit3, fit_measure = "rmsea")
plot_models_fm(fit, fit2, fit3, fit_measure = "rmsea",
               include_model_values = TRUE)

}
\seealso{
\code{\link[lavaan:fitMeasures]{lavaan::fitMeasures()}}
}
\author{
Shu Fai Cheung \url{https://orcid.org/0000-0002-9871-9448}
}
