% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/input-search.R
\name{updateSearchInput}
\alias{updateSearchInput}
\title{Change the value of a search input on the client}
\usage{
updateSearchInput(
  session,
  inputId,
  label = NULL,
  value = NULL,
  placeholder = NULL,
  trigger = FALSE
)
}
\arguments{
\item{session}{The \code{session} object passed to function given to \code{shinyServer}.}

\item{inputId}{The id of the input object.}

\item{label}{The label to set for the input object.}

\item{value}{The value to set for the input object.}

\item{placeholder}{The placeholder to set for the input object.}

\item{trigger}{Logical, update value server-side as well.}
}
\description{
Change the value of a search input on the client
}
\note{
By default, only UI value is updated, use \code{trigger = TRUE} to update both UI and Server value.
}
\examples{
if (interactive()) {

library(shiny)
library(shinyWidgets)

ui <- fluidPage(
  tags$h2("Update searchinput"),
  searchInput(
    inputId = "search", label = "Enter your text",
    placeholder = "A placeholder",
    btnSearch = icon("magnifying-glass"),
    btnReset = icon("xmark"),
    width = "450px"
  ),
  br(),
  verbatimTextOutput(outputId = "res"),
  br(),
  textInput(
    inputId = "update_search",
    label = "Update search"
  ),
  checkboxInput(
    inputId = "trigger_search",
    label = "Trigger update search",
    value = TRUE
  )
)

server <- function(input, output, session) {

  output$res <- renderPrint({
    input$search
  })

  observeEvent(input$update_search, {
    updateSearchInput(
      session = session,
      inputId = "search",
      value = input$update_search,
      trigger = input$trigger_search
    )
  }, ignoreInit = TRUE)
}

shinyApp(ui, server)

}
}
