% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_members.R
\name{fit_members}
\alias{fit_members}
\title{Fit model stack members with non-zero stacking coefficients}
\usage{
fit_members(model_stack, ...)
}
\arguments{
\item{model_stack}{A \code{model_stack} object outputted by \code{\link[=blend_predictions]{blend_predictions()}}.}

\item{...}{Additional arguments. Currently ignored.}
}
\value{
A \code{model_stack} object with a subclass \code{linear_stack}---this fitted
model contains the necessary components to predict on new data.
}
\description{
After evaluating a data stack with \code{\link[=blend_predictions]{blend_predictions()}},
some number of candidates will have nonzero stacking
coefficients. Such candidates are referred to as "members."
Since members' predictions will ultimately inform the model
stack's predictions, members should be trained on the full
training set using \code{fit_members()}.
}
\details{
To fit members in parallel, please register a parallel backend function.
See the documentation of \code{\link[foreach:foreach]{foreach::foreach()}} for examples.
}
\section{Example Data}{


This package provides some resampling objects and datasets for use in examples
and vignettes derived from a study on 1212 red-eyed tree frog embryos!

Red-eyed tree frog (RETF) embryos can hatch earlier than their normal
7ish days if they detect potential predator threat. Researchers wanted
to determine how, and when, these tree frog embryos were able to detect
stimulus from their environment. To do so, they subjected the embryos
at varying developmental stages to "predator stimulus" by jiggling
the embryos with a blunt probe. Beforehand, though some of the embryos
were treated with gentamicin, a compound that knocks out their lateral
line (a sensory organ.) Researcher Julie Jung and her crew found that
these factors inform whether an embryo hatches prematurely or not!

Note that the data included with the stacks package is not necessarily
a representative or unbiased subset of the complete dataset, and is
only for demonstrative purposes.

\code{reg_folds} and \code{class_folds} are \code{rset} cross-fold validation objects
from \code{rsample}, splitting the training data into for the regression
and classification model objects, respectively. \code{tree_frogs_reg_test} and
\code{tree_frogs_class_test} are the analogous testing sets.

\code{reg_res_lr}, \code{reg_res_svm}, and \code{reg_res_sp} contain regression tuning results
for a linear regression, support vector machine, and spline model, respectively,
fitting \code{latency} (i.e. how long the embryos took to hatch in response
to the jiggle) in the \code{tree_frogs} data, using most all of the other
variables as predictors. Note that the data underlying these models is
filtered to include data only from embryos that hatched in response to
the stimulus.

\code{class_res_rf} and \code{class_res_nn} contain multiclass classification tuning
results for a random forest and neural network classification model,
respectively, fitting \code{reflex} (a measure of ear function) in the
data using most all of the other variables as predictors.

\code{log_res_rf} and \code{log_res_nn}, contain binary classification tuning results
for a random forest and neural network classification model, respectively,
fitting \code{hatched} (whether or not the embryos hatched in response
to the stimulus) using most all of the other variables as predictors.

See \code{?example_data} to learn more about these objects, as well as browse
the source code that generated them.
}

\examples{
\dontshow{if ((stacks:::should_run_examples(suggests = c("ranger", "kernlab")))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

# see the "Example Data" section above for
# clarification on the objects used in these examples!

# put together a data stack
reg_st <- 
  stacks() \%>\%
  add_candidates(reg_res_lr) \%>\%
  add_candidates(reg_res_svm) \%>\%
  add_candidates(reg_res_sp)
  
reg_st

# evaluate the data stack and fit the member models
reg_st \%>\%
  blend_predictions() \%>\%
  fit_members()
  
reg_st
  
# do the same with multinomial classification models
class_st <-
  stacks() \%>\%
  add_candidates(class_res_nn) \%>\%
  add_candidates(class_res_rf) \%>\%
  blend_predictions() \%>\%
  fit_members()
  
class_st
  
# ...or binomial classification models
log_st <-
  stacks() \%>\%
  add_candidates(log_res_nn) \%>\%
  add_candidates(log_res_rf) \%>\%
  blend_predictions() \%>\%
  fit_members()
  
log_st
\dontshow{\}) # examplesIf}
}
\seealso{
Other core verbs: 
\code{\link{add_candidates}()},
\code{\link{blend_predictions}()},
\code{\link{stacks}()}
}
\concept{core verbs}
