% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_seasonal}
\alias{plot_seasonal}
\title{Seasonal Diagnostic Plot for an stlplus Object}
\usage{
plot_seasonal(x, col = c("darkgray", "black"), lwd = 2, xlab = "Time",
  ylab = "Centered Seasonal + Remainder", ...)
}
\arguments{
\item{x}{object of class \code{"stlplus"}.}

\item{col, lwd, xlab, ylab, \ldots}{parameters to be passed to \code{xyplot()}.}
}
\value{
object of class \code{"trellis"}.
}
\description{
Plots each cycle-subseries of the detrended data (or equivalently,
seasonal plus remainder), with the mean subtracted.  The fitted seasonal
component is plotted as a line through the points.
}
\details{
Helps decide how much of the variation in the data other than the trend should go into the seasonal component, and how much in the remainder.
}
\references{
R. B. Cleveland, W. S. Cleveland, J. E.  McRae, and I. Terpenning (1990) STL:  A  Seasonal-Trend  Decomposition  Procedure Based on Loess. \emph{Journal of Official Statistics}, \bold{6}, 3--73.
}
\seealso{
\code{\link{stlplus}}
}

