% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simul_rlg.R
\name{simula.rlg}
\alias{simula.rlg}
\title{Simulate contaminated data set for applying rlg}
\usage{
simula.rlg(q = 2, p = 10, n = 200, var = 0.01, sep.means = 0, alpha = 0.05)
}
\arguments{
\item{q}{intrinsic dimension}

\item{p}{dimension (\code{p >= 2} and \code{p > q})}

\item{n}{number of observations}

\item{var}{The smaller 'var' the smaller the scatter around the lower dimensional space}

\item{sep.means}{Parameter controlling the location vectors separation}

\item{alpha}{contamination level}
}
\value{
a list with the following items
\itemize{
    \item x - The generated dataset
    \item true - The true classification
}
}
\description{
Simulate alpha*100\% contaminated data set for applying rlg by 
 generating a k=3 components with equal size  and            # 
 common underlying dimension q_1=q_2=q_3=q
}
\examples{
 res <- simula.rlg(q=5, p=200, n=150, var=0.01, sep.means=0.00)
 plot(res$x,col=res$true+1)

}
