% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename_dt.R
\name{rename_dt}
\alias{rename_dt}
\alias{rename_with_dt}
\title{Rename column in data.frame}
\usage{
rename_dt(.data, ...)

rename_with_dt(.data, .fn, ...)
}
\arguments{
\item{.data}{data.frame}

\item{...}{statements of rename, e.g. `sl = Sepal.Length` means the column named
as "Sepal.Length" would be renamed to "sl"}

\item{.fn}{A function used to transform the selected columns.
Should return a character vector the same length as the input.}
}
\value{
data.table
}
\description{
Rename one or more columns in the data.frame.
}
\examples{
iris \%>\%
  rename_dt(sl = Sepal.Length,sw = Sepal.Width) \%>\%
  head()
iris \%>\% rename_with_dt(toupper)
iris \%>\% rename_with_dt(toupper,"^Pe")

}
\seealso{
\code{\link[dplyr]{rename}}
}
