% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarise-SpatVector.R
\name{summarise.SpatVector}
\alias{summarise.SpatVector}
\alias{summarize.SpatVector}
\title{Summarise each group of a SpatVector down to one geometry}
\usage{
\method{summarise}{SpatVector}(.data, ..., .by = NULL, .groups = NULL, .dissolve = TRUE)

\method{summarize}{SpatVector}(.data, ..., .by = NULL, .groups = NULL, .dissolve = TRUE)
}
\arguments{
\item{.data}{A SpatVector}

\item{...}{<\code{\link[rlang:args_data_masking]{data-masking}}> Name-value pairs of
summary functions. The name will be the name of the variable in the result.

The value can be:
\itemize{
\item A vector of length 1, e.g. \code{min(x)}, \code{n()}, or \code{sum(is.na(y))}.
\item A data frame, to add multiple columns from a single expression.
}

\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Returning values with size 0 or >1 was
deprecated as of 1.1.0. Please use \code{\link[dplyr:reframe]{reframe()}} for this instead.}

\item{.by}{Ignored on this method. \ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
on \pkg{dplyr}.}

\item{.groups}{See \code{\link[dplyr:summarise]{dplyr::summarise()}}}

\item{.dissolve}{logical. Should borders between aggregated geometries
be dissolved?}
}
\value{
A SpatVector.
}
\description{
\code{summarise()} creates a new SpatVector. It returns one geometry for each
combination of grouping variables; if there are no grouping variables, the
output will have a single geometry summarising all observations in the input
and combining all the geometries of the SpatVector. It will contain one
column for each grouping variable and one column for each of
the summary statistics that you have specified.

\code{summarise.SpatVector()} and \code{summarize.SpatVector()} are synonyms
}
\section{terra equivalent}{


\code{\link[terra:aggregate]{terra::aggregate()}}
}

\section{Methods}{


Implementation of the \strong{generic} \code{\link[dplyr:summarise]{dplyr::summarise()}} function.
\subsection{SpatVector}{

Similarly to the implementation on \pkg{sf} this function can be used to
dissolve geometries (with \code{.dissolve = TRUE}) or create \code{MULTI} versions of
geometries (with \code{.dissolve = FALSE}). See \strong{Examples}.
}
}

\examples{
library(terra)
library(ggplot2)

v <- vect(system.file("extdata/cyl.gpkg", package = "tidyterra"))

# Grouped
gr_v <- v \%>\%
  mutate(start_with_s = substr(name, 1, 1) == "S") \%>\%
  group_by(start_with_s)


# Dissolving
diss <- gr_v \%>\%
  summarise(n = dplyr::n(), mean = mean(as.double(cpro)))

diss

autoplot(diss, aes(fill = start_with_s)) + ggplot2::ggtitle("Dissolved")

# Not dissolving
no_diss <- gr_v \%>\%
  summarise(n = dplyr::n(), mean = mean(as.double(cpro)), .dissolve = FALSE)

# Same statistic
no_diss

autoplot(no_diss, aes(fill = start_with_s)) +
  ggplot2::ggtitle("Not Dissolved")
}
\seealso{
\code{\link[dplyr:summarise]{dplyr::summarise()}}, \code{\link[terra:aggregate]{terra::aggregate()}}

Other single table verbs: 
\code{\link{arrange.SpatVector}()},
\code{\link{filter.Spat}},
\code{\link{mutate.Spat}},
\code{\link{rename.Spat}},
\code{\link{select.Spat}},
\code{\link{slice.Spat}}

Other dplyr verbs that operate on group of rows:
\code{\link{count.SpatVector}()},
\code{\link{group-by.SpatVector}},
\code{\link{rowwise.SpatVector}()}

Other dplyr methods:
\code{\link{arrange.SpatVector}()},
\code{\link{bind_cols.SpatVector}},
\code{\link{bind_rows.SpatVector}},
\code{\link{count.SpatVector}()},
\code{\link{distinct.SpatVector}()},
\code{\link{filter-joins.SpatVector}},
\code{\link{filter.Spat}},
\code{\link{glimpse.Spat}},
\code{\link{group-by.SpatVector}},
\code{\link{mutate-joins.SpatVector}},
\code{\link{mutate.Spat}},
\code{\link{pull.Spat}},
\code{\link{relocate.Spat}},
\code{\link{rename.Spat}},
\code{\link{rowwise.SpatVector}()},
\code{\link{select.Spat}},
\code{\link{slice.Spat}}
}
\concept{dplyr.groups}
\concept{dplyr.methods}
\concept{single table verbs}
