% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat_summarise.R
\docType{data}
\name{stat_summarise}
\alias{stat_summarise}
\alias{.stat_fns}
\title{Fast grouped statistical summary for data frames.}
\format{
\code{.stat_fns}

An object of class \code{character} of length 13.
}
\usage{
stat_summarise(
  data,
  ...,
  stat = .stat_fns[1:5],
  q_probs = NULL,
  na.rm = TRUE,
  sort = TRUE,
  .names = NULL,
  .by = NULL,
  .cols = NULL,
  as_tbl = FALSE
)

.stat_fns
}
\arguments{
\item{data}{A data frame.}

\item{...}{Variables to apply the statistical functions to.
Tidy data-masking applies.}

\item{stat}{A character vector of statistical summaries to apply.
This can be one or more of the following: \cr
"n", "nmiss", "min", "max", "mean", "first", "last", "sd",
"var", "mode", "median", "sum", "prop_complete".}

\item{q_probs}{(Optional) Quantile probabilities.
If supplied, \code{q_summarise()} is called and added to the result.}

\item{na.rm}{Should \code{NA} values be removed? Default is \code{TRUE}.}

\item{sort}{Should groups be sorted? Default is \code{TRUE}.}

\item{.names}{An optional glue specification passed to \code{stringr::glue()}.
If \code{.names = NULL}, then when there is 1 variable, the function name
is used, i.e \code{.names = "{.fn}"}, when there are multiple variables and
1 function, the variable names are used, i.e, \code{.names = "{.col}"}
and in the case of multiple variables and functions.
\code{"{.col}_{.fn}"} is used.}

\item{.by}{(Optional). A selection of columns to group by for this operation.
Columns are specified using tidy-select.}

\item{.cols}{(Optional) alternative to \code{...} that accepts
a named character vector or numeric vector.
If speed is an expensive resource, it is recommended to use this.}

\item{as_tbl}{Should the result be a \code{tibble}? Default is \code{FALSE}.}
}
\value{
A summary \code{data.table} containing the summary values for each group.
}
\description{
\code{collapse} and \code{data.table} are used for the calculations.
}
\details{
\code{stat_summarise()} can apply multiple functions to multiple variables.

\code{stat_summarise()} is equivalent to \cr
\code{data \%>\% group_by(...) \%>\% summarise(across(..., list(...)))} \cr
but is faster and more efficient and accepts limited statistical functions.
}
\examples{
library(timeplyr)
library(dplyr)
\dontshow{
.n_dt_threads <- data.table::getDTthreads()
.n_collapse_threads <- collapse::get_collapse()$nthreads
data.table::setDTthreads(threads = 2L)
collapse::set_collapse(nthreads = 1L)
}
stat_df <- iris \%>\%
  stat_summarise(Sepal.Length, .by = Species)
# Join quantile info too
q_df <- iris \%>\%
  q_summarise(Sepal.Length, .by = Species)
summary_df <- left_join(stat_df, q_df, by = "Species")
summary_df

# Multiple cols
iris \%>\%
  group_by(Species) \%>\%
  stat_summarise(across(contains("Width")),
            stat = c("min", "max", "mean", "sd"))
\dontshow{
data.table::setDTthreads(threads = .n_dt_threads)
collapse::set_collapse(nthreads = .n_collapse_threads)
}
}
\seealso{
\link{q_summarise}
}
\keyword{datasets}
